/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 6, example 1.
 *
 *  Header file for "MultFloatVec3f" engine.
 *------------------------------------------------------------*/

#include "MultFloatVec3f.h"

SO_ENGINE_SOURCE(MultFloatVec3f);

//
// Initializes the MultFloatVec3f class. This is a one-time
// thing that is done after database initialization and before
// any instance of this class is constructed.
//

void
MultFloatVec3f::initClass()
{
   // Initialize type id variables. The arguments to the macro
   // are: the name of the engine class and the class this is
   // derived from.
   SO_ENGINE_INIT_CLASS(MultFloatVec3f, SoEngine, "Engine");
}

void
MultFloatVec3f::exitClass()
{
   SO_ENGINE_EXIT_CLASS(MultFloatVec3f);
}


//
// Constructor
//

MultFloatVec3f::MultFloatVec3f()
{
   // Do standard constructor stuff
   SO_ENGINE_CONSTRUCTOR(MultFloatVec3f);

   // Define input fields and their default values
   SO_ENGINE_ADD_INPUT(scalar,  (0.0));
   SO_ENGINE_ADD_INPUT(vector,  (0.0, 0.0, 0.0));

   // Define the output, specifying its type
   SO_ENGINE_ADD_OUTPUT(product, SoSFVec3f);
}

//
// Destructor. Does nothing.
//

MultFloatVec3f::~MultFloatVec3f()
{
}

//
// This is the evaluation routine.
//

void
MultFloatVec3f::evaluate()
{
   // Compute the product of the input fields
   SbVec3f  prod = scalar.getValue() * vector.getValue();

   // "Send" the value to the output. In effect, we are setting
   // the value in all fields to which this output is connected.
   SO_ENGINE_OUTPUT(product, SoSFVec3f, setValue(prod));
}


