/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 6, example 6.
 *
 *  Source file for "SoDecomposeVec2f" engine.
 *------------------------------------------------------------*/

#include "SoDecomposeVec2f.h"

SO_ENGINE_SOURCE(SoDecomposeVec2f);

//
// Initializes the SoDecomposeVec2f class.
//

void
SoDecomposeVec2f::initClass()
{
   SO_ENGINE_INIT_CLASS(SoDecomposeVec2f, SoEngine, "Engine");
}

void
SoDecomposeVec2f::exitClass()
{
   SO_ENGINE_EXIT_CLASS(SoDecomposeVec2f);
}


//
// Constructor
//

SoDecomposeVec2f::SoDecomposeVec2f()
{
   // Do standard constructor stuff
   SO_ENGINE_CONSTRUCTOR(SoDecomposeVec2f);

   // Define input field and its default value
   SO_ENGINE_ADD_INPUT(vector,  (0.0, 0.0));

   // Define the outputs, specifying their types
   SO_ENGINE_ADD_OUTPUT(x, SoMFFloat);
   SO_ENGINE_ADD_OUTPUT(y, SoMFFloat);
}

//
// Destructor. Does nothing.
//

SoDecomposeVec2f::~SoDecomposeVec2f()
{
}

//
// This is the evaluation routine.
//

void
SoDecomposeVec2f::evaluate()
{
   // Figure out how many input values we have
   int numToOutput = vector.getNum();

   // Make sure that all of the fields connected from the
   // outputs have enough room for the results. The
   // SoMField::setNum() method does this.
   SO_ENGINE_OUTPUT(x, SoMFFloat, setNum(numToOutput));
   SO_ENGINE_OUTPUT(y, SoMFFloat, setNum(numToOutput));

   // Now output the values extracted from the input vectors
   for (int i = 0; i < numToOutput; i++) {
      SO_ENGINE_OUTPUT(x, SoMFFloat,
                       set1Value(i, vector[i][0]));
      SO_ENGINE_OUTPUT(y, SoMFFloat,
                       set1Value(i, vector[i][1]));
   }
}


