/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 6, example 10.
 *
 *  Source file for "Ticker" engine.
 *------------------------------------------------------------*/

#include <Inventor/SoDB.h>
#include "Ticker.h"

SO_ENGINE_SOURCE(Ticker);

//
// Initializes the Ticker class.
//

void
Ticker::initClass()
{
   SO_ENGINE_INIT_CLASS(Ticker, SoEngine, "Engine");
}

void
Ticker::exitClass()
{
   SO_ENGINE_EXIT_CLASS(Ticker);
}


//
// Constructor
//

Ticker::Ticker()
{
   // Do standard constructor stuff
   SO_ENGINE_CONSTRUCTOR(Ticker);

   // Define input field and its default value
   SO_ENGINE_ADD_INPUT(timeIn,  (SbTime::zero()));

   // Define the output, specifying its type
   SO_ENGINE_ADD_OUTPUT(timeOut, SoSFTime);

   // Initialize the variable that stores the number of seconds
   // of the last time the input changed
   lastSeconds = -1.0;

   // Connect to the global "realTime" field by default. This
   // way, users do not have to make this connection explicitly,
   // and can change it if they want.
   timeIn.connectFrom(SoDB::getGlobalField("realTime"));
}

//
// Destructor. Does nothing.
//

Ticker::~Ticker()
{
}

//
// This is called when one of our input fields changes. We will
// use it to determine whether to produce any output. Since we
// have only 1 input field, we don't have to see which field
// changed.
//

void
Ticker::inputChanged(SoField *)
{

   // Get the current input time and get rid of any fractional
   // part, using the math library's floor() function
   SbTime   currentTime = timeIn.getValue();
   double   currentSeconds = floor(currentTime.getValue());

   // If the new number of seconds is different from the last
   // one we stored, enable the output. The next time this
   // engine is evaluated, the time will be output.
   if (currentSeconds != lastSeconds) {
      timeOut.enable(TRUE);
      lastSeconds = currentSeconds;
   }

   // Otherwise, make sure the output is disabled, since we
   // don't want to output any values until we cross the next
   // second barrier.
   else
      timeOut.enable(FALSE);
}

//
// This is the evaluation routine.
//

void
Ticker::evaluate()
{
   // Output the current number of seconds
   SbTime   currentTime(lastSeconds);
   SO_ENGINE_OUTPUT(timeOut, SoSFTime, setValue(currentTime));
}


