/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 7, examples 4 through 8.
 *
 *  Source file for "JumpingJackKit" 
 *------------------------------------------------------------*/

// This define causes the declaration of initClass in the node's
// header file to be declared _declspec(dllexport).  This is required
// for the entry point to be visible outside the DLL.
#define BUILDING_DLL

#include <Inventor/SoPickedPoint.h>
#include <Inventor/events/SoMouseButtonEvent.h>
#include <Inventor/nodekits/SoShapeKit.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoCylinder.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoTransform.h>

#include "JumpingJackKit.h"


SO_KIT_SOURCE(JumpingJackKit);

void
JumpingJackKit::initClass()
{
   SO_KIT_INIT_CLASS(JumpingJackKit, SoBaseKit, "BaseKit");
}

void
JumpingJackKit::exitClass()
{
   SO__KIT_EXIT_CLASS(JumpingJackKit);
}

JumpingJackKit::JumpingJackKit()
{
   SO_KIT_CONSTRUCTOR(JumpingJackKit);

   // Add the body parts to the catalog...
   SO_KIT_ADD_CATALOG_ENTRY(body, SoShapeKit, 
      TRUE, this,\x0, TRUE);
   SO_KIT_ADD_CATALOG_ENTRY(head, SoShapeKit, 
      TRUE, this,\x0, TRUE);
   SO_KIT_ADD_CATALOG_ENTRY(leftArm, SoShapeKit, 
      TRUE, this,\x0, TRUE);
   SO_KIT_ADD_CATALOG_ENTRY(rightArm, SoShapeKit, 
      TRUE, this,\x0, TRUE);
   SO_KIT_ADD_CATALOG_ENTRY(leftLeg, SoShapeKit, 
      TRUE, this,\x0, TRUE);
   SO_KIT_ADD_CATALOG_ENTRY(rightLeg, SoShapeKit, 
      TRUE, this,\x0, TRUE);

   SO_KIT_INIT_INSTANCE();

   createInitialJack();
}

JumpingJackKit::~JumpingJackKit()
{
}

// This kit is made up entirely of SoShapeKits.
// Since SoShapeKits do not affect state, neither does this.
SbBool
JumpingJackKit::affectsState() const
{
   return FALSE;
}

// Set up parts for default configuration of the jumping jack
void
JumpingJackKit::createInitialJack()
{
   // Create the head.
   SoSphere *headSphere = new SoSphere;
   setPart("head.shape", headSphere);

   // Create the body.
   SoCube *bodyCube = new SoCube;
   setPart("body.shape", bodyCube);

   // Create the limbs
   SoCylinder *limbCylinder = new SoCylinder;
   setPart("leftLeg.shape",  limbCylinder);
   setPart("leftArm.shape",  limbCylinder);
   setPart("rightLeg.shape", limbCylinder);
   setPart("rightArm.shape", limbCylinder);

   // Place the body and head
   set((char *)"body.transform", (char *)"scaleFactor 1 2 1");
   set((char *)"head.transform", (char *)"translation 0 3 0");

   // Place the limbs
   set((char *)"leftArm.transform",  (char *)"scaleFactor 0.5 1.5 0.5");
   set((char *)"leftLeg.transform",  (char *)"scaleFactor 0.5 1.5 0.5");
   set((char *)"rightArm.transform", (char *)"scaleFactor 0.5 1.5 0.5");
   set((char *)"rightLeg.transform", (char *)"scaleFactor 0.5 1.5 0.5");
   set((char *)"leftArm.transform",  (char *)"center 0 1 0");
   set((char *)"leftLeg.transform",  (char *)"center 0 1 0");
   set((char *)"rightArm.transform", (char *)"center 0 1 0");
   set((char *)"rightLeg.transform", (char *)"center 0 1 0");
   set((char *)"leftArm.transform",  (char *)"translation -1  1   0.5");
   set((char *)"leftLeg.transform",  (char *)"translation -1 -2.5 0.5");
   set((char *)"rightArm.transform", (char *)"translation  1  1   0.5");
   set((char *)"rightLeg.transform", (char *)"translation  1 -2.5 0.5");

   // Create the Event Callback to make jack jump.
   // When it receives a mouse button event, it will
   // call the method jumpJackJump.
   SoEventCallback *myEventCB = new SoEventCallback;
   myEventCB->addEventCallback(
      SoMouseButtonEvent::getClassTypeId(), 
      JumpingJackKit::jumpJackJump, this);
   setPart("callbackList[0]",  myEventCB);
}

// Animates the jumping jack (called by the "eventCallback[0]" 
// part when a left mouse button press occurs).
void
JumpingJackKit::jumpJackJump(void *userData, 
                             SoEventCallback *myEventCB)
{
   const SoEvent *myEvent = myEventCB->getEvent();

   // see if it's a left mouse down event
   if (SO_MOUSE_PRESS_EVENT(myEvent, BUTTON1)) {
      JumpingJackKit *myJack = (JumpingJackKit *) userData;

      // See if the jumping jack was picked.
      const SoPickedPoint *myPickedPoint;
      myPickedPoint = myEventCB->getPickedPoint();
      if (myPickedPoint && myPickedPoint->getPath() &&
         myPickedPoint->getPath()->containsNode(myJack)) {

         // The jumping jack was picked. Make it jump!
         SoTransform *myXf;
         SbVec3f zAxis(0,0,1);
         SbRotation noRot = SbRotation::identity();

         myXf = SO_GET_PART(myJack,
	    "leftArm.transform",SoTransform);
         if (myXf->rotation.getValue() == noRot)
            myXf->rotation.setValue(zAxis ,-1.6f);
         else
            myXf->rotation.setValue(noRot);

         myXf = SO_GET_PART(myJack,
	    "leftLeg.transform",SoTransform);
         if (myXf->rotation.getValue() == noRot)
            myXf->rotation.setValue(zAxis ,-1.2f);
         else
            myXf->rotation.setValue(noRot);
         myXf = SO_GET_PART(myJack,
	    "rightArm.transform",SoTransform);
         if (myXf->rotation.getValue() == noRot)
            myXf->rotation.setValue(zAxis , 1.6f);
         else
            myXf->rotation.setValue(noRot);

         myXf = SO_GET_PART(myJack,
	    "rightLeg.transform",SoTransform);
         if (myXf->rotation.getValue() == noRot)
            myXf->rotation.setValue(zAxis , 1.2f);
         else
            myXf->rotation.setValue(noRot);
         myEventCB->setHandled();
      }
   }
}

