/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 7, example 3.
 *
 *  Source file for "PyramidKit" 
 *------------------------------------------------------------*/

#include <Inventor/SoDB.h>

// This define causes the declaration of initClass in the node's
// header file to be declared _declspec(dllexport).  This is required
// for the entry point to be visible outside the DLL.
#define BUILDING_DLL

// Include files for new classes
#include "Pyramid.h"
#include "PyramidKit.h"

SO_KIT_SOURCE(PyramidKit);

void
PyramidKit::initClass()
{
   SO_KIT_INIT_CLASS(PyramidKit, SoShapeKit, "ShapeKit");
}

void
PyramidKit::exitClass()
{
   SO__KIT_EXIT_CLASS(PyramidKit);
}


PyramidKit::PyramidKit()
{
   SO_KIT_CONSTRUCTOR(PyramidKit);

   // Change the 'shape' part to be a Pyramid node.
   SO_KIT_CHANGE_ENTRY_TYPE(shape, Pyramid, Pyramid );

   SO_KIT_INIT_INSTANCE();

   // Create 
}

PyramidKit::~PyramidKit()
{
}

