/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*-------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 8, example 18 
 *
 *  Header file for "Coordinate3Manip"
 *
 *  This is a subclass of SoCoordinate3.
 *  It adds functionality to add a dragger as a hidden child. 
 *  The child, when dragged, will affect the fields of this 
 *  SoCoordinate3Manip through a collection of methods added 
 *  in this subclass.
 *
 *----------------------------------------------------------*/

#ifndef  _COORDINATE3_MANIP_
#define  _COORDINATE3_MANIP_

#include <Inventor/draggers/SoDragger.h>
#include <Inventor/fields/SoSFInt32.h>
#include <Inventor/nodes/SoCoordinate3.h>
#include <Inventor/sensors/SoFieldSensor.h>

class Coordinate3Manip : public SoCoordinate3
{
  SO_NODE_HEADER(Coordinate3Manip);

 public:
  // Constructor
  Coordinate3Manip();

  // The index of the 'point' field that will be edited 
  // by our child-dragger.
  SoSFInt32 editIndex;

  // Returns the dragger node being employed by this manip.
  SoDragger *getDragger();

  virtual SoNode *copy(SbBool copyConnections = FALSE) const;

  // For replacing a regular SoCoordinate3 node with this
  // manipulator.
  SbBool replaceNode(SoPath *p);

  // For replacing this manipulator with a regular 
  // SoCoordinate3 node.
  SbBool replaceManip(SoPath *p, SoCoordinate3 *newOne) const;

  // These functions implement all actions for this manip.
  // They first traverse the children, then use the 
  // SoCoordinate3 version of the actions. They traverse first 
  // so that the SoCoordinate3 will affect objects which 
  // follow it in the tree, but not the dragger-child.
  virtual void doAction(SoAction *action);
  virtual void callback(SoCallbackAction *action);
  virtual void GLRender(SoGLRenderAction *action);
  virtual void getBoundingBox(SoGetBoundingBoxAction *action);
  virtual void getMatrix(SoGetMatrixAction *action);
  virtual void handleEvent(SoHandleEventAction *action);
  virtual void pick(SoPickAction *action);
  virtual void search(SoSearchAction *action);

  // call this after SoInteraction::init();
  static void initClass();
  static void exitClass();

  virtual SoChildList *getChildren() const;

 protected:
  // When the dragger moves, this interprets the translation 
  // field of the dragger and sets the point field of this 
  // node accordingly.
  static void valueChangedCB(void *,SoDragger *);

  // When the point field of this node changes, moves the
  // child-dragger to a new location, if necessary.
  SoFieldSensor *pointFieldSensor;
  static void fieldSensorCB(void *, SoSensor *);

  // Establishes the given dragger as the new child-dragger
  void setDragger(SoDragger *newDragger);

  // The hidden children.
  SoChildList *children;

  // Destructor
  ~Coordinate3Manip();

 private:
  int getNumChildren() const { return (children->getLength()); }
};    

#endif  /* _COORDINATE3_MANIP_ */


