/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 8, example 14.
 *
 *  Header file for "RotTransDragger"
 *
 *  This is the source file for the RotTransDragger.
 *  It is a compound dragger which allows independent rotation 
 *  in the x,y,and z directions as well as translation along a 
 *  line. It is an example of how to write a compound dragger.
 *
 *  It is composed of a TranslateRadialDragger and 
 *  3 SoRotateCylindricalDraggers bound into one dragger.
 *
 *  Clicking on the TranslateRadialDragger piece results in a
 *  translational motion along the line formed by the center of
 *  the dragger and the point on the dragger that was hit.
 *
 *  Clicking a cylinder rotator results in a rotation about 
 *  either the x,y,or z axis.
 *
 *  Geometry resources and part names for this dragger:
 *
 *  Resource Names:                     Part Names:
 *rotTransTranslatorTranslator       translator.translator
 *rotTransTranslatorTranslatorActive translator.translatorActive
 *rotTransTranslatorFeedback         translator.feedback
 *rotTransTranslatorFeedbackActive   translator.feedbackActive
 *
 *rotTransRotatorRotator             XRotator.rotator
 *rotTransRotatorRotatorActive       XRotator.rotatorActive
 *rotTransRotatorFeedback            XRotator.feedback
 *rotTransRotatorFeedbackActive      XRotator.feedbackActive
 *     (and similarly for parts of the YRotator and ZRotator)
 *
 *-----------------------------------------------------------*/
 
#ifndef  _ROT_TRANS_DRAGGER_
#define  _ROT_TRANS_DRAGGER_

#include <Inventor/sensors/SoFieldSensor.h>
#include <Inventor/draggers/SoDragger.h>
#include <Inventor/fields/SoSFVec3f.h>
#include <Inventor/fields/SoSFRotation.h>

class TranslateRadialDragger;
class SoRotateCylindricalDragger;

class RotTransDragger : public SoDragger
{
  SO_KIT_HEADER(RotTransDragger);

  // Makes the dragger surround other objects
  SO_KIT_CATALOG_ENTRY_HEADER(surroundScale);
  // Keeps the dragger evenly sized in all 3 dimensions
  SO_KIT_CATALOG_ENTRY_HEADER(antiSquish);

  // The translating dragger...
  SO_KIT_CATALOG_ENTRY_HEADER(translator);

  // The X and Z rotators need to be turned so as to orient 
  // correctly. So create a separator part and put an 
  // SoRotation node and the dragger underneath.
  SO_KIT_CATALOG_ENTRY_HEADER(XRotatorSep);
  SO_KIT_CATALOG_ENTRY_HEADER(XRotatorRot);
  SO_KIT_CATALOG_ENTRY_HEADER(XRotator);

  SO_KIT_CATALOG_ENTRY_HEADER(YRotator);

  SO_KIT_CATALOG_ENTRY_HEADER(ZRotatorSep);
  SO_KIT_CATALOG_ENTRY_HEADER(ZRotatorRot);
  SO_KIT_CATALOG_ENTRY_HEADER(ZRotator);

 public:
  // Constructor
  RotTransDragger();

  // These fields reflect state of the dragger at all times.
  SoSFRotation rotation;
  SoSFVec3f   translation;

  // This should be called once after SoInteraction::init().
  static void initClass();
  static void exitClass();

 protected:
  // These sensors insures that the motionMatrix is updated 
  // when the fields are changed from outside.
  SoFieldSensor *rotFieldSensor;
  SoFieldSensor *translFieldSensor;
  static void fieldSensorCB(void *, SoSensor *);

  // This function is invoked by the child draggers when they 
  // change their value.
  static void valueChangedCB(void *, SoDragger *);

  // Called at the beginning and end of each dragging motion.
  // Tells the "surroundScale" part to recalculate.
  static void invalidateSurroundScaleCB(void *, SoDragger *);

  // This will detach/attach the fieldSensor.
  // It is called at the end of the constructor (to attach).
  // and at the start/end of SoBaseKit::readInstance()
  // and on the new copy at the start/end of SoBaseKit::copy()
  // Returns the state of the node when this was called.
  virtual SbBool setUpConnections( SbBool onOff, 
				   SbBool doItAlways = FALSE);

  // This allows us to specify that certain parts do not
  // write out. We'll use this on the antiSquish and
  // surroundScale parts.
  virtual void setDefaultOnNonWritingFields();

  // Destructor.
  ~RotTransDragger();

 private:

  static const char geomBuffer[];
};   

#endif  /* _ROT_TRANS_DRAGGER_ */


