/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*-------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 8, example 17
 *
 *  Source file for "RotTransManip"
 *
 *----------------------------------------------------------*/

#include <Inventor/nodes/SoSurroundScale.h>

#include "RotTransDragger.h"
#include "RotTransManip.h"

SO_NODE_SOURCE(RotTransManip);

//  Initialize the type ID for this manipulator node. This
//  should be called once after SoInteraction::init(),
//  TranslateRadialDragger::initClass()
//  and RotTransDragger::initClass()
void
RotTransManip::initClass()
{
    if (RotTransDragger::getClassTypeId().isBad())
        RotTransDragger::initClass();
   getClassRenderEngineMode().setRenderMode(SbRenderEngineMode::OIV_OPENINVENTOR_RENDERING);
   SO_NODE_INIT_CLASS(RotTransManip, SoTransformManip, "TransformManip");
}

void 
RotTransManip::exitClass()
{
  SO__NODE_EXIT_CLASS(RotTransManip);
}

RotTransManip::RotTransManip()
{
   SO_NODE_CONSTRUCTOR(RotTransManip);

   // Create a new dragger and call setDragger(), 
   // a method inherited from SoTransformManip.
   RotTransDragger *myDrag = new RotTransDragger;
   setDragger(myDrag);

   // We want this manipulator to surround the objects it
   // affects when we put it in a scene. So create the
   // surroundScale node.
   SoSurroundScale* mySS = myDrag->getPart<SoSurroundScale>( "surroundScale" );
   mySS->numNodesUpToContainer = 4;
   mySS->numNodesUpToReset = 3;
}

RotTransManip::~RotTransManip()
{
}


