/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 8, example 2.
 *
 *  Header file for "TranslateRadialDragger"
 *
 *  This is a simple dragger which allows translation 
 *  along a line. It is used as an example of how to write a 
 *  simple dragger.
 *
 *  It operates by allowing the user to click on the dragger,
 *  then dragging along the line formed by the center of the 
 *  dragger and the point on the dragger that was hit.
 *
 *  Resource names and part names for this dragger are:
 *      Resource Name:                        Part Name:
 *	translateRadialTranslator             translator
 *	translateRadialTranslatorActive       translatorActive
 *	translateRadialFeedback               feedback
 *	translateRadialFeedbackActive         feedbackActive
 *
 *------------------------------------------------------------*/

#ifndef  _TRANSLATE_RADIAL_DRAGGER_
#define  _TRANSLATE_RADIAL_DRAGGER_

#include <Inventor/draggers/SoDragger.h>
#include <Inventor/fields/SoSFVec3f.h>
#include <Inventor/sensors/SoFieldSensor.h>

class SbLineProjector;

class TranslateRadialDragger : public SoDragger
{
  SO_KIT_HEADER(TranslateRadialDragger);

  // Catalog entries for new parts added by this class...
  SO_KIT_CATALOG_ENTRY_HEADER(translatorSwitch);
  SO_KIT_CATALOG_ENTRY_HEADER(translator);
  SO_KIT_CATALOG_ENTRY_HEADER(translatorActive);
  SO_KIT_CATALOG_ENTRY_HEADER(feedbackRotate);
  SO_KIT_CATALOG_ENTRY_HEADER(feedbackSwitch);
  SO_KIT_CATALOG_ENTRY_HEADER(feedback);
  SO_KIT_CATALOG_ENTRY_HEADER(feedbackActive);

 public:
  // Constructor
  TranslateRadialDragger();

  // Field that will always contain the dragger's position
  SoSFVec3f translation;

  // Initialize the class. This should be called once
  // after SoInteraction::init().
  static void initClass();
  static void exitClass();

 protected:
  void orientFeedbackGeometry(const SbVec3f &localDir);

  // projector used for calculating motion along a line.
  SbLineProjector *lineProj;

  // Static callback functions invoked by SoDragger when the 
  // mouse button goes down over this dragger, when the
  // mouse drags, and when the button is released.
  static void startCB(void *, SoDragger *);
  static void motionCB(void *, SoDragger *);
  static void finishCB(void *, SoDragger *);

  // These functions, invoked by the static callback 
  // functions, do all the work of moving the dragger.
  void dragStart();
  void drag();
  void dragFinish();

  // This sensor watches for changes to the translation field
  SoFieldSensor *fieldSensor;
  static void fieldSensorCB(void *, SoSensor *);

  // This callback updates the translation field when 
  // the dragger is moved.
  static void valueChangedCB(void *, SoDragger *);

  // This will detach/attach the fieldSensor.
  // It is called at the end of the constructor (to attach).
  // and at the start/end of SoBaseKit::readInstance()
  // and on the new copy at the start/end of SoBaseKit::copy()
  // Returns the state of the node when this was called.
  virtual SbBool setUpConnections( SbBool onOff, 
				   SbBool doItAlways = FALSE);

  // Destructor.
  ~TranslateRadialDragger();

 private:
  static const char geomBuffer[];
};    

#endif  /* _TRANSLATE_RADIAL_DRAGGER_ */


