/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*-------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 8, an example not printed in the book.
 *
 *  Source file for "TranslateRadialManip"
 *
 *----------------------------------------------------------*/

#include <Inventor/nodes/SoSurroundScale.h>

#include "TranslateRadialDragger.h"
#include "TranslateRadialManip.h"

SO_NODE_SOURCE(TranslateRadialManip);

//  Initializes the type ID for this manipulator node. This
//  should be called once after SoInteraction::init().
//  and after TranslateRadialDragger::initClass()
void
TranslateRadialManip::initClass()
{
    if (TranslateRadialDragger::getClassTypeId().isBad())
        TranslateRadialDragger::initClass();
   getClassRenderEngineMode().setRenderMode(SbRenderEngineMode::OIV_OPENINVENTOR_RENDERING);
   SO_NODE_INIT_CLASS(
      TranslateRadialManip, SoTransformManip, "TransformManip");		
}

void
TranslateRadialManip::exitClass()
{
   SO__NODE_EXIT_CLASS(TranslateRadialManip);
}

//  Constructor. 
TranslateRadialManip::TranslateRadialManip()
{
   SO_NODE_CONSTRUCTOR(TranslateRadialManip);
   
   // Create a new dragger and call setDragger(), 
   // a method inherited from SoTransformManip.
   TranslateRadialDragger *myDrag = new TranslateRadialDragger;
   setDragger(myDrag);
}

TranslateRadialManip::~TranslateRadialManip()
{
}


