/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 8.
 *
 *  This program initializes the node classes from this chapter,
 *  reads a scene graph from "newManips.iv", writes the graph to 
 *  stdout, and renders the graph in an examiner viewer.
 *------------------------------------------------------------*/

#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/actions/SoWriteAction.h>
#include <Inventor/nodes/SoSeparator.h>

// Header files for new node classes
#include "TranslateRadialDragger.h"
#include "RotTransDragger.h"
#include "TranslateRadialManip.h"
#include "RotTransManip.h"
#include "Coordinate3Manip.h"



int
main(int, char **argv)
{
  
  SoInput myInput;
  SoSeparator *root;
  
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL) exit(1);
  
  // Initialize the new node classes
  TranslateRadialDragger::initClass();
  RotTransDragger::initClass();
  TranslateRadialManip::initClass();
  RotTransManip::initClass();
  Coordinate3Manip::initClass();
  
  if (! myInput.openFile("$OIVHOME/examples/source/Inventor/A_GettingStarted/ToolMaker/08.Manips/newManips.iv")) {
    fprintf(stderr, "Can't open \"newManips.iv\"\n");
    exit(1);
  }
  
  root = SoDB::readAll(&myInput);
  if (root == NULL) {
    printf("File \"newManips.iv\" contains bad data\n");
    exit(2);
  }
  
  root->ref();
  
  // Write the graph to stdout
  SoWriteAction wa;
  wa.apply(root);
  
  // Render it
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("New Manips");
  myViewer->show();
  myViewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  root->unref();

  delete myViewer;

  // Initialize the new node classes
  Coordinate3Manip::exitClass();
  RotTransManip::exitClass();
  TranslateRadialManip::exitClass();
  RotTransDragger::exitClass();
  TranslateRadialDragger::exitClass();

  SoXt::finish();
  return 0;
}


