/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*-------------------------------------------------------------
 *  This is an example from The Inventor Toolmaker,
 *  chapter 9.
 *
 *  This example demonstrates creating a new highlight style
 *  by subclassing from SoGLRenderAction.
 *------------------------------------------------------------*/

#ifdef _WIN32
#  include <windows.h>
#  include <Inventor/actions/SoBoxHighlightRenderAction.h>
#else
#  include <X11/StringDefs.h>
#  include <X11/Intrinsic.h>
#endif

#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSelection.h>

#include "ShowSelectionRA.h"


int
main(int, char** argv)
{
  // Initialization
  Widget mainWindow = SoXt::init(argv[0]);
  ShowSelectionRenderAction::initClass();
  
  // Open the data file
  SoInput in;   
  char *datafile = "$OIVHOME/examples/data/Inventor/monitor.iv";
  
  if (! in.openFile(datafile)) {
    fprintf(stderr, "Cannot open %s for reading.\n", datafile);
    return 1;
  }
  
  // Read the input file
  SoNode *n;
  SoSeparator *sep = new SoSeparator;
  while ((SoDB::read(&in, n) != FALSE) && (n != NULL))
    sep->addChild(n);
  
  // Create a selection root to show off our new highlight.
  SoSelection *sel = new SoSelection;
  sel->addChild(sep);
  
  // Create two viewers, one to show the scene, the other
  // to show the selected objects.
  SoXtExaminerViewer *viewer1 = new SoXtExaminerViewer(mainWindow);
  viewer1->setSceneGraph(sel);
  viewer1->setTitle("Scene");
  
#ifdef _WIN32
  HWND hwnd;
  RECT rect;
  GetWindowRect( mainWindow, &rect );
  hwnd = CreateWindow("button",
                      "selection",
                      WS_OVERLAPPEDWINDOW | BS_OWNERDRAW,
                      rect.right + 1,       // X position
                      rect.top,             // Y position
                      rect.right,           // Width
                      rect.bottom,          // Height
                      NULL,                 // Parent
                      NULL,                 // Menu
                      SoWin::getInstance(), // App instance handle
                      NULL);                // Window creation data

  SoXtExaminerViewer *viewer2 = new SoXtExaminerViewer( hwnd );
  ShowWindow( hwnd, SW_SHOWNORMAL );
#else
  SoXtExaminerViewer *viewer2 = new SoXtExaminerViewer();
#endif
  viewer2->setSceneGraph(sel);
  viewer2->setGLRenderAction(new ShowSelectionRenderAction());    
  viewer2->redrawOnSelectionChange(sel);
  viewer2->setDecoration(FALSE);
  viewer2->setTitle("Selection");
  
  viewer1->show();
  viewer2->show();
  
  SoXt::show(mainWindow);
  SoXt::mainLoop();

  delete viewer1;
  delete viewer2;

  ShowSelectionRenderAction::exitClass();
  SoXt::finish();

  return 0;
}



