/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 9.
 *
 *  Source file for "ShowSelection" highlight.
 *------------------------------------------------------------*/


#include <Inventor/SoPath.h>
#include <Inventor/actions/SoSearchAction.h>
#include <Inventor/nodes/SoNode.h>
#include <Inventor/nodes/SoLightModel.h>
#include <Inventor/nodes/SoBaseColor.h>
#include <Inventor/nodes/SoDrawStyle.h>
#include <Inventor/nodes/SoSelection.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTexture2.h>

#include "ShowSelectionRA.h"


SO_ACTION_SOURCE(ShowSelectionRenderAction);

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Initializes the ShowSelectionRenderAction class.
//
void
ShowSelectionRenderAction::initClass()
//
////////////////////////////////////////////////////////////////////////
{
   SO_ACTION_INIT_CLASS(ShowSelectionRenderAction, SoGLRenderAction);
}

void
ShowSelectionRenderAction::exitClass()
//
////////////////////////////////////////////////////////////////////////
{
   SO_ACTION_EXIT_CLASS(ShowSelectionRenderAction);
}


////////////////////////////////////////////////////////////////////////
//
//  Constructor
//
ShowSelectionRenderAction::ShowSelectionRenderAction()
	: SoGLRenderAction(SbVec2s(1, 1)) // pass a dummy viewport region
//
////////////////////////////////////////////////////////////////////////
{
   selPath = NULL;
   m_emptySeparator = new SoSeparator;
}    

////////////////////////////////////////////////////////////////////////
//
//  Destructor
//
ShowSelectionRenderAction::~ShowSelectionRenderAction()
//
////////////////////////////////////////////////////////////////////////
{
   if (selPath != NULL)
      selPath->unref();
}    

////////////////////////////////////////////////////////////////////////
//
//  Render the passed scene by searching for the first selection node,
//  then rendering only the selected objects.
//
void
ShowSelectionRenderAction::apply(SoNode *node)
//
////////////////////////////////////////////////////////////////////////
{
   node->ref();
   
   // Do we have to search for the selection node?
   // Only if our cached path is NULL, 
   // or the action is being applied to a different scene,
   // or the tail of our existing path is no longer a selection
   // node (for instance if that node was removed from the scene).
   if ((selPath == NULL) ||
       (selPath->getHead() != node) ||
       (! selPath->getTail()->isOfType(
              SoSelection::getClassTypeId()))) {
   
      // Find the first selection node under the passed root
      SoSearchAction sa;
      sa.setFind(SoSearchAction::TYPE);
      sa.setInterest(SoSearchAction::FIRST);
      sa.setType(SoSelection::getClassTypeId());
      sa.apply(node);
   
      // Cache this new path
      if (selPath != NULL)
         selPath->unref();
      selPath = sa.getPath();
      if (selPath != NULL) {
         selPath = selPath->copy();
         selPath->ref();
      }
   }
   
   // Render the selected paths!
   if (selPath != NULL) {	
      SoSelection *sel = (SoSelection *) selPath->getTail();
      if (sel->getNumSelected() > 0) {
         // Keep the length from the root to the selection
         // as an optimization so we can reuse this data
         int reusablePathLength = selPath->getLength();

         // For each selection path, we need the full path from
	 // the passed root to render, else we may not have a camera.
         for (int j = 0; j < sel->getNumSelected(); j++) {
            // Continue the path down to the selected object.
            // No need to deal with p[0] since that is the sel node.
            SoPath *p = sel->getPath(j);
            for (int k = 1; k < p->getLength(); k++)
               selPath->append(p->getIndex(k));

            // Render the selected shape
            SoGLRenderAction::apply(selPath);
	
            // Restore selPath for reuse
            selPath->truncate(reusablePathLength);
         }
      }
      else
      {
        // In any cases, SoGLRenderAction::apply() must be called so that OpenInventor will properly
        // handle rendering. Else, there may be garbage in frame.
        // So if nothing is selected, we have to call apply() on a dummy empty node
        SoGLRenderAction::apply(m_emptySeparator.ptr());
      }
   }


   node->unref();
}    

//
// Function stubs: we do not highlight paths and pathLists.
//
void
ShowSelectionRenderAction::apply(SoPath *path)
{ SoGLRenderAction::apply(path); }

void
ShowSelectionRenderAction::apply(const SoPathList &pathList, SbBool obeysRules)
{ SoGLRenderAction::apply(pathList, obeysRules); }


