/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 9.
 *
 *  Header file for "ShowSelection" highlight.
 *------------------------------------------------------------*/

#ifndef _SHOW_SELECTION_RENDER_ACTION_
#define _SHOW_SELECTION_RENDER_ACTION_

#include <Inventor/actions/SoGLRenderAction.h>

class SoPath;

class ShowSelectionRenderAction : public SoGLRenderAction {
   SO_ACTION_HEADER(ShowSelectionRenderAction);
  public:
   ShowSelectionRenderAction();
   virtual ~ShowSelectionRenderAction();

   // Applies action to the graph rooted by a node,
   // only drawing selected objects.
   virtual void    apply(SoNode *node);
   
   // Applies action to the graph defined by a path or path list.
   // These simply invoke the parent class apply() methods.
   // These do NOT highlight the path, whether selected or not.
   // They are implemented to keep the compiler happy.
   virtual void    apply(SoPath *path);
   virtual void    apply(const SoPathList &pathList,
			 SbBool obeysRules = FALSE);

   static void initClass();
   static void exitClass();
   
  protected:
   // We will cache the path to the first selection node
   SoPath	    *selPath;

   // Dummy empty node that is used when nothing has been selected.
   SoRef<SoSeparator> m_emptySeparator;
};

#endif /* _SHOW_SELECTION_RENDER_ACTION_ */


