#if !defined(__APPLE__)
#  include <X11/StringDefs.h>
#  include <X11/Intrinsic.h>
#endif

#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSelection.h>

#include <Inventor/actions/SoColorHighlightRenderAction.h>

SbString Title("highlight demo");

void
fpsCB(float fps, void *, SoXtViewer *viewer) {
  SbString titleStr(Title) ;
  SbString fpsStr;
  fpsStr.setNum(fps);
  titleStr += " fps: ";
  titleStr += fpsStr;
  viewer->setTitle(titleStr.getString());
}

int
main(int argc, char *argv[])
{
  // Initialization
  Widget mainWindow = SoXt::init(argv[0]);
  SoColorHighlightRenderAction::initClass();
  
  // Open the data file
  SoInput in;   
  const char *datafile = "$OIVHOME/examples/data/Inventor/monitor.iv";
  if (! in.openFile(argc > 1 ? argv[1] : datafile)) {
    fprintf(stderr, "Cannot open %s for reading.\n", datafile);
    exit(-1);
  }
  
  // Read the input file
  SoNode *n;
  SoSeparator *sep = new SoSeparator;
  while ((SoDB::read(&in, n) != FALSE) && (n != NULL))
    sep->addChild(n);
  
  // Create a selection root to show off our new highlight.
  SoSelection *sel = new SoSelection;
  sel->addChild(sep);
  
  SoXtExaminerViewer *viewer1 = new SoXtExaminerViewer(mainWindow);
  viewer1->setSceneGraph(sel);
  viewer1->setTitle(Title);
  viewer1->setFramesPerSecondCallback(fpsCB);
  viewer1->setGLRenderAction(new SoColorHighlightRenderAction());
  viewer1->redrawOnSelectionChange(sel);
  
  viewer1->show();
  
  SoXt::show(mainWindow);
  SoXt::mainLoop();

  SoColorHighlightRenderAction::exitClass();
  SoXt::finish();

  return 0;
}

