/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 10.
 *
 *  Header file for "SceneTumble" component.
 *------------------------------------------------------------*/

#ifndef _SCENE_TUMBLE_
#define _SCENE_TUMBLE_

#include <Inventor/Xt/SoXtRenderArea.h>

class SoSeparator;
class SoPerspectiveCamera;
class SoRotation;
class SoTimerSensor;

class SceneTumble : public SoXtRenderArea {

   public:
   
   // Constructor for public consumption
   SceneTumble(
      Widget parent = NULL,
      const char *name = NULL, 
      SbBool buildInsideParent = TRUE);
   ~SceneTumble();

   virtual void	setSceneGraph(SoNode *newScene);
   virtual SoNode *getSceneGraph();

   void setTumbling(SbBool onOff);
   SbBool isTumbling() const;
    
    
   protected:
   
   // Constructor subclasses can call if they don't want the
   // widget built right away (i.e. the subclass wants to create
   // a container widget first.)
   SceneTumble(
      Widget parent,
      const char *name, 
      SbBool buildInsideParent, 
      SbBool buildNow);

   Widget buildWidget(Widget parent);

   void doTumbleAnimation();

   void setSpeed(int s) { speed = s; }
   int getSpeed() const { return speed; }

   Widget speedSlider;
    
    
   private:
   
   void constructorCommon(SbBool buildNow);
   static void visibilityChangeCB(void *userData, SbBool visible);
   static void animationSensorCB(void *userData, SoSensor *);
   static void speedCB(Widget, XtPointer, XtPointer);
   
   SoNode      *userScene;
   SoSeparator *root;
   SoPerspectiveCamera *camera;
   SoRotation *rotx;
   SoRotation *roty;
   SoRotation *rotz;
   int speed;
   SoTimerSensor *animationSensor;
}; 

#endif /* _SCENE_TUMBLE_ */


