/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Alain Dumesny (MMM yyyy)
**=======================================================================*/


#ifndef  _SIMPLE_VIEWER_
#define  _SIMPLE_VIEWER_

#include <Inventor/Xt/viewers/SoXtFullViewer.h>
#include <Inventor/SbLinear.h>


//////////////////////////////////////////////////////////////////////////////
//
//  Class: simpleViewer
//
//	simpleViewer - viewer which translates the camera 
//  in the viewer plane.
//
//////////////////////////////////////////////////////////////////////////////

class simpleViewer : public SoXtFullViewer {
 public:
    // constructor/destructor
    simpleViewer(
	Widget parent = NULL,
	const char *name = NULL, 
	SbBool buildInsideParent = TRUE, 
	SoXtFullViewer::BuildFlag flag = BUILD_ALL, 
	SoXtViewer::Type type = BROWSER);
    ~simpleViewer();
    
    // redefine this to also change the cursor (viewerCursor)
    virtual void	setViewing(SbBool onOrOff);
    
 protected:
    // redefine this to process the events
    virtual void	processEvent(XAnyEvent *anyevent);
    
    // redefine this to also change the cursor (seekCursor)
    virtual void	setSeekMode(SbBool onOrOff);
    
    // Define those thumb wheels to translate in the viewer plane
    virtual void    	bottomWheelMotion(float newVal);
    virtual void    	leftWheelMotion(float newVal);
    virtual void    	rightWheelMotion(float newVal);
    virtual void    	bottomWheelStart();
    virtual void    	leftWheelStart();
    
    // redefine this to customize the preference sheet
    virtual void	createPrefSheet();
    
    // Define this to bring the viewer help card
    virtual void	openViewerHelpCard();
    
 private:
    // viewer state variables
    int		    mode;
    SbBool	    createdCursors;
    Cursor	    vwrCursor, seekCursor;
    SbVec2s	    locator; // mouse position
    
    // camera translation vars
    SbVec3f	    locator3D;
    SbPlane	    focalplane;
    float	    transXspeed, transYspeed;
    
    void	    switchMode(int newMode);
    void	    defineCursors();
    void	    translateCamera();
    void	    computeTranslateValues();
};

#endif  /* _SIMPLE_VIEWER_ */


