/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

#include <stdio.h>
#include <Inventor/SoDB.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoWWWInline.h>
#include "SceneTumble.h"

int
main(int argc, char *argv[])
{
  if (argc != 2) {
    fprintf(stderr, "Usage: %s <filename.iv>\n", argv[0]);
    exit(-1);
  }
   
  Widget window = SoXt::init(argv[0]);

  SoInput in;
  SoSeparator *scene = NULL;
  if (in.openFile(argv[1])) {
    SoWWWInline::setReadAsSoFile(TRUE);

    scene = SoDB::readAll(&in);
    in.closeFile();
  }
   
  if (scene == NULL) {
    fprintf(stderr, "Sorry, could not read %s\n", argv[1]);;
    exit(-1);
  }
   
  SceneTumble *tumbler = new SceneTumble(window);
  tumbler->setSceneGraph(scene);
  tumbler->show();
  SoXt::show(window); // do this AFTER showing the GLX widget
  SoXt::mainLoop();

  return 0;
}


