/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*-------------------------------------------------------------
 *  This is an example from The Inventor Toolmaker,
 *  chapter 11.
 *
 *  This is the header file for the "ButtonBox" event.
 *------------------------------------------------------------*/

#include "ButtonBoxEvent.h"


SO_EVENT_SOURCE(ButtonBoxEvent);


////////////////////////////////////////////////////////////////////////
//
// Class initialization
//
// SoINTERNAL public
//
void
ButtonBoxEvent::initClass()
//
////////////////////////////////////////////////////////////////////////
{
   SO_EVENT_INIT_CLASS(ButtonBoxEvent, SoButtonEvent);
}

void
ButtonBoxEvent::exitClass()
{
   SO_EVENT_EXIT_CLASS(ButtonBoxEvent);
}

////////////////////////////////////////////////////////////////////////
//
// Constructor
//
ButtonBoxEvent::ButtonBoxEvent()
//
////////////////////////////////////////////////////////////////////////
{
   button = 0;
}

////////////////////////////////////////////////////////////////////////
//
// Convenience routine - this returns TRUE if the event is a button box
// press event matching the passed button.
//
// static public
//
SbBool
ButtonBoxEvent::isButtonPressEvent(const SoEvent *e, int whichButton)
//
////////////////////////////////////////////////////////////////////////
{
   SbBool isMatch = FALSE;
   
   // is it a button box event?
   if (e->isOfType(ButtonBoxEvent::getClassTypeId())) {
      const ButtonBoxEvent *be = (const ButtonBoxEvent *) e;
   
      // is it a press event?
      if (be->getState() == SoButtonEvent::DOWN) {
   
         // did the caller want any button press? or do they match?
         if ((whichButton == -1) ||
             (be->getButton() == whichButton))
            isMatch = TRUE;
      }
   }
   
   return isMatch;
}

////////////////////////////////////////////////////////////////////////
//
// Convenience routine - this returns TRUE if the event is a button box
// release event matching the passed button.
//
// static public
//
SbBool
ButtonBoxEvent::isButtonReleaseEvent(const SoEvent *e, int whichButton)
//
////////////////////////////////////////////////////////////////////////
{
   SbBool isMatch = FALSE;
   
   // is it a button box event?
   if (e->isOfType(ButtonBoxEvent::getClassTypeId())) {
      const ButtonBoxEvent *be = (const ButtonBoxEvent *) e;
   
      // is it a release event?
      if (be->getState() == SoButtonEvent::UP) {
      
         // did the caller want any button release? or do they match?
         if ((whichButton == -1) ||
             (be->getButton() == whichButton))
            isMatch = TRUE;
      }
   }
   
   return isMatch;
}

