/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*-------------------------------------------------------------
 *  This is an example from The Inventor Toolmaker,
 *  chapter 11.
 *
 *  This is the header file for the "ButtonBox" event.
 *------------------------------------------------------------*/


#ifndef  _BUTTON_BOX_EVENT_
#define  _BUTTON_BOX_EVENT_

#include <Inventor/SbBasic.h>
#include <Inventor/events/SoButtonEvent.h>
#include <Inventor/events/SoSubEvent.h>

// some convenience macros for determining if an event matches
#define BUTTON_BOX_PRESS_EVENT(EVENT,BUTTON) \
   (ButtonBoxEvent::isButtonPressEvent(EVENT,BUTTON))

#define BUTTON_BOX_RELEASE_EVENT(EVENT,BUTTON) \
   (ButtonBoxEvent::isButtonReleaseEvent(EVENT,BUTTON))

// The ButtonBoxEvent class
class ButtonBoxEvent : public SoButtonEvent {

   SO_EVENT_HEADER();
   
  public:
   // constructor
   ButtonBoxEvent();
   
   // which button generated the event, e.g. ButtonBoxEvent::BUTTON1
   void     setButton(int b) { button = b; }
   int	    getButton() const  { return button; }
   
   // convenience routines to see if an SoEvent is a press or release
   // of the passed button box button. Passing -1 matches any button.
   static SbBool         isButtonPressEvent(
                           const SoEvent *e,
                           int whichButton = -1);
			    
   static SbBool         isButtonReleaseEvent(
                           const SoEvent *e,
                           int whichButton = -1);
    
  SoINTERNAL public:
   static void		initClass();
   static void		exitClass();
   
  private:
   int   		button;		    // which button
};

#endif /* _BUTTON_BOX_EVENT_ */


