/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*-------------------------------------------------------------
 *  This is an example from The Inventor Toolmaker,
 *  chapter 11.
 *
 *  This is the source file for the "Dial" event.
 *------------------------------------------------------------*/

#include "DialEvent.h"

SO_EVENT_SOURCE(DialEvent);

////////////////////////////////////////////////////////////////////////
//
// Class initialization
//
// SoINTERNAL public
//
void
DialEvent::initClass()
//
////////////////////////////////////////////////////////////////////////
{
   SO_EVENT_INIT_CLASS(DialEvent, SoEvent);
}

void
DialEvent::exitClass()
{
   SO_EVENT_EXIT_CLASS(DialEvent);
}

////////////////////////////////////////////////////////////////////////
//
// Constructor
//
DialEvent::DialEvent()
//
////////////////////////////////////////////////////////////////////////
{
   dial = 0;
   value = 0;
}

////////////////////////////////////////////////////////////////////////
//
// Convenience routine - this returns TRUE if the event is a dial
// turn event matching the passed dial.
//
// static public
//
SbBool
DialEvent::isDialEvent(const SoEvent *e, int whichDial)
//
////////////////////////////////////////////////////////////////////////
{
   SbBool isMatch = FALSE;
   
   // is it a dial event?
   if (e->isOfType(DialEvent::getClassTypeId())) {
      const DialEvent *de = (const DialEvent *) e;
   
      // did the caller want any dial turn? or do they match?
      if ((whichDial == -1) ||
          (de->getDial() == whichDial))
         isMatch = TRUE;
   }
   
   return isMatch;
}


