/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*-------------------------------------------------------------
 *  This is an example from The Inventor Toolmaker,
 *  chapter 11.
 *
 *  This is the header file for the "Dial" event.
 *------------------------------------------------------------*/


#ifndef  _DIAL_EVENT_
#define  _DIAL_EVENT_

#include <Inventor/SbBasic.h>
#include <Inventor/events/SoEvent.h>
#include <Inventor/events/SoSubEvent.h>

// convenience macro for determining if an event matches
#define DIAL_EVENT(EVENT, WHICH) \
   (DialEvent::isDialEvent(EVENT, WHICH))


// The DialEvent class
class DialEvent : public SoEvent {

   SO_EVENT_HEADER();
   
  public:
   // constructor
   DialEvent();
   
   // which dial generated the event, 1-8
   void     setDial(int d)   { dial = d; }
   int	    getDial() const  { return dial; }
    
   // value of the dial turned
   void     setValue(int v)  { value = v; }
   int	    getValue() const { return value; }
   
   // convenience routines to see if an SoEvent is a turn of
   // the passed dial. Passing -1 matches any button.
   static SbBool	isDialEvent(const SoEvent *e, int which = -1);
   
  SoINTERNAL public:
   static void		initClass();
   static void		exitClass();
   
  private:
   int   		dial;		    // which dial
   int			value;		    // value of dial
};

#endif /* _DIAL_EVENT_ */


