/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*-------------------------------------------------------------
 *  This is an example from The Inventor Toolmaker,
 *  chapter 11.
 *
 *  This is the header file for the "DialNButton" device.
 *------------------------------------------------------------*/

#ifndef  _DIAL_N_BUTTON_
#define  _DIAL_N_BUTTON_

#include <X11/X.h>
#include <X11/extensions/XInput.h>
#include <Inventor/Xt/devices/SoXtDevice.h>
#include <Inventor/events/SoButtonEvent.h>

class ButtonBoxEvent;
class DialEvent;

class DialNButton : public SoXtDevice {
  public:
   // The first constructor uses the display set when SoXt::init is called.
   DialNButton();
   DialNButton(Display *d);
   ~DialNButton();
   
   // these functions will enable/disable this device for the widget.
   // the callback function f will be invoked when events occur in w.
   // data is the clientData which will be passed.
   virtual void        enable(Widget w, XtEventHandler f,
                           XtPointer data, Window win = 0);
   virtual void        disable(Widget w, XtEventHandler f,
                           XtPointer data);
   
   //
   // this converts an X event into an SoEvent,
   // returning NULL if the event is not from this device.
   //
   virtual const SoEvent * translateEvent(XAnyEvent *xevent);
   
   // Return whether or not the dial+button device exists for use.
   // The first uses the display set when SoXt::init is called.
   static SbBool	exists() { return exists(SoXt::getDisplay()); }
   static SbBool	exists(Display *d);
   
  protected:
   // initialize the device
   static void		init(Display *d);
   static SbBool	firstTime;
   
   // these event types are retrieved from the X server at run time
   static int		motionEventType;
   static int		buttonPressEventType;
   static int		buttonReleaseEventType;
   
   // event classes passed to XSelectExtensionEvent
   static XEventClass	eventClasses[3]; // max of 3 event classes for this
   static int		eventTypes[3];	 // max of 3 event types for this
   
   // device id is set at runtime
   static XDevice	*device;
   
   // inventor events generated by this device
   ButtonBoxEvent	*buttonEvent;
   DialEvent		*dialEvent;

   // event translators!
   DialEvent	   *translateMotionEvent(XDeviceMotionEvent *me);
   ButtonBoxEvent  *translateButtonEvent(
                        XDeviceButtonEvent *be,
                        SoButtonEvent::State whichState);
};

#endif /* _DIAL_N_BUTTON_ */


