/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Jean-Paul Digeon (Apr 2011)
**=======================================================================*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <DialogViz/SoDialogVizAll.h>
#include <Inventor/nodes/SoGradientBackground.h>
#include <Inventor/draggers/SoDragger.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/SoType.h>
#include <Inventor/SoPreferences.h>
#include "utils.h"

#define  DRAGGER_DIR "$OIVHOME/data/draggerWysiwyg"
#define	 INTERFACE_FILE  "$OIVHOME/examples/source/Inventor/DraggerBenchmark/interface.iv"

int main(int, char **argv)
{
	// Initialize Inventor. This returns a main window to use.
	// If unsuccessful, exit.
	Widget myWindow = SoXt::init(argv[0]); // pass the app name
	if (myWindow == NULL) 
		return 1;

	SoPreferences::setString( "SO_DRAGGER_DIR", DRAGGER_DIR);

	
	SoSeparator *root = new SoSeparator;
	SoGradientBackground * bg = new SoGradientBackground;
	SoSwitch*	dragSwitch = new SoSwitch;
	root->ref();
	root->addChild(bg);
	root->addChild(dragSwitch);

	
	//Add an instance of all kinds of dragger in the switch
	SoTypeList draggerTypeList;
	int nbDragger = SoType::getAllDerivedFrom(   SoDragger::getClassTypeId() , draggerTypeList);

	for (int i = 1; i < nbDragger; i++)
	{
		SoType draggerType =   draggerTypeList[i];
		SoDragger* theDragger= (SoDragger*) draggerType.createInstance();

		dragSwitch->addChild( theDragger );
	}

	dragSwitch->whichChild.setValue(0);

	//build interface 
	SoDialogViz::init();

	const SbString InterfaceName = INTERFACE_FILE;
	SoInput myInputInterface;
	if ( !myInputInterface.openFile(InterfaceName) ) 
	{
		std::cerr << "Cannot open " << InterfaceName.getString() << std::endl;
		exit(1);
	}

	SoGroup *myGroup = SoDB::readAll( &myInputInterface );
	if ( !myGroup )
	{  
		fprintf(stderr, "Cannot create interface.");
		exit(1);
	}
	myGroup->ref();

	SoTopLevelDialog* myTop = find<SoTopLevelDialog>( myGroup );
	myTop->ref();


	SoDialogCustom* myCustom = find<SoDialogCustom>( myTop, "DIALOG_CUSTOM" );


	// combo box to select dragger
	SoDialogRadioButtons* draggerRadio = find<SoDialogRadioButtons>( myTop, "DRAGGER_RADIO" );
	dragSwitch->whichChild.connectFrom(&draggerRadio->selectedItem);

	for (int i = 1; i < nbDragger; i++)
	{
		SoType draggerType =   draggerTypeList[i];
        draggerType.createInstance();

		SbString   s= draggerType.getName().getString();
		draggerRadio->items.set1Value(i-1, s );
	}
	myTop->buildDialog( myWindow, true );
	SoXtExaminerViewer *myRenderArea = new SoXtExaminerViewer(myCustom->getWidget());

	// Put our scene in myRenderArea, change the title
	myRenderArea->setSceneGraph(root);
	myRenderArea->setTitle("Dragger Benchmark");
	myRenderArea->show();

	SoXt::show(myWindow);  // Display main window
	SoXt::mainLoop();      // Main Inventor event loop

  root->unref();
  delete myRenderArea;
  SoDialogViz::finish();
	SoXt::finish();

	return 0;
}


