/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

//////////////////////////////////////////////////////////////////
//
// Dealing with Xt/Xm arguments
//

#define ARG_VARS(num)							      \
    Cardinal    argN = 0;						      \
    Arg         args[num]

#define ADD_ARG(resource, value)					      \
		XtSetArg(args[argN], resource, value); argN++

#define RESET_ARGS()    argN = 0
#define ARGS            args, argN

//////////////////////////////////////////////////////////////////
//
// Dealing with form arguments
//

#define ADD_LEFT_FORM(offset)						      \
    ADD_ARG(XmNleftAttachment,		XmATTACH_FORM);			      \
    ADD_ARG(XmNleftOffset,		offset)

#define ADD_LEFT_WIDGET(widget, offset)					      \
    ADD_ARG(XmNleftAttachment,		XmATTACH_WIDGET);		      \
    ADD_ARG(XmNleftWidget,		widget);			      \
    ADD_ARG(XmNleftOffset,		offset)

#define ADD_RIGHT_FORM(offset)						      \
    ADD_ARG(XmNrightAttachment,		XmATTACH_FORM);			      \
    ADD_ARG(XmNrightOffset,		offset)

#define ADD_RIGHT_WIDGET(widget, offset)				      \
    ADD_ARG(XmNrightAttachment,		XmATTACH_WIDGET);		      \
    ADD_ARG(XmNrightWidget,		widget);			      \
    ADD_ARG(XmNrightOffset,		offset)

#define ADD_TOP_FORM(offset)						      \
    ADD_ARG(XmNtopAttachment,		XmATTACH_FORM);			      \
    ADD_ARG(XmNtopOffset,		offset)

#define ADD_TOP_WIDGET(widget, offset)					      \
    ADD_ARG(XmNtopAttachment,		XmATTACH_WIDGET);		      \
    ADD_ARG(XmNtopWidget,		widget);			      \
    ADD_ARG(XmNtopOffset,		offset)

#define ADD_BOTTOM_FORM(offset)						      \
    ADD_ARG(XmNbottomAttachment,	XmATTACH_FORM);			      \
    ADD_ARG(XmNbottomOffset,		offset)

#define ADD_BOTTOM_WIDGET(widget, offset)				      \
    ADD_ARG(XmNbottomAttachment,	XmATTACH_WIDGET);		      \
    ADD_ARG(XmNbottomWidget,		widget);			      \
    ADD_ARG(XmNbottomOffset,		offset)

//////////////////////////////////////////////////////////////////
//
// Dealing with Xm strings
//

#define STRING(a) XmStringCreateSimple(a)


#if JUST_FOR_CUT_AND_PASTE
    ADD_LEFT_FORM(0);
    ADD_LEFT_WIDGET(w, 0);

    ADD_RIGHT_FORM(0);
    ADD_RIGHT_WIDGET(w, 0);

    ADD_TOP_FORM(0);
    ADD_TOP_WIDGET(w, 0);

    ADD_BOTTOM_FORM(0);
    ADD_BOTTOM_WIDGET(w, 0);
#endif


