/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*
 _______________________________________________________________________
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 |
 |
 |   Classes	: TsField::buildBlock
 |
 |   Author	: Dave Immel
 |
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 _______________________________________________________________________
 */

//--------------------------- Include ----------------------------------
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>

#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoCoordinate3.h>
#include <Inventor/nodes/SoIndexedFaceSet.h>
#include <Inventor/nodes/SoNormal.h>
#include "TsField.h"


////////////////////////////////////////////////////////////////////////
//
// Description:
//	Initialize the Inventor data representing the block.  The block
//      is the basic unit from which all of the pieces are built.  It
//      is instanced for all pieces and the field.  The block is centered at
//      (1, 1, -1) and as length of 2.
//
// Use: private

void
TsField::buildBlock()

//
////////////////////////////////////////////////////////////////////////
{
  SoCoordinate3 *coords;
  SoIndexedFaceSet *faces;
  SoNormal *normals;
  SbVec3f *verts, tcoord;
  int32_t *indices, *ind;
  int i;
  
  block = new SoSeparator();
  block->ref();
  
  verts = new SbVec3f[24];
  // Front
  verts[0].setValue(0.1F, 0.1F, 0.0F);
  verts[1].setValue(1.9F, 0.1F, 0.0F);
  verts[2].setValue(1.9F, 1.9F, 0.0F);
  verts[3].setValue(0.1F, 1.9F, 0.0F);
  // Right
  verts[4].setValue(2.0F, 0.1F, -0.1F);
  verts[5].setValue(2.0F, 0.1F, -1.9F);
  verts[6].setValue(2.0F, 1.9F, -1.9F);
  verts[7].setValue(2.0F, 1.9F, -0.1F);
  // Back
  verts[8].setValue(1.9F, 0.1F, -2.0F);
  verts[9].setValue(0.1F, 0.1F, -2.0F);
  verts[10].setValue(0.1F, 1.9F, -2.0F);
  verts[11].setValue(1.9F, 1.9F, -2.0F);
  // Left
  verts[12].setValue(0.0F, 0.1F, -1.9F);
  verts[13].setValue(0.0F, 0.1F, -0.1F);
  verts[14].setValue(0.0F, 1.9F, -0.1F);
  verts[15].setValue(0.0F, 1.9F, -1.9F);
  // Bottom
  verts[16].setValue(0.1F, 0.0F, -1.9F);
  verts[17].setValue(1.9F, 0.0F, -1.9F);
  verts[18].setValue(1.9F, 0.0F, -0.1F);
  verts[19].setValue(0.1F, 0.0F, -0.1F);
  // Top
  verts[20].setValue(0.1F, 2.0F, -0.1F);
  verts[21].setValue(1.9F, 2.0F, -0.1F);
  verts[22].setValue(1.9F, 2.0F, -1.9F);
  verts[23].setValue(0.1F, 2.0F, -1.9F);
  coords = new SoCoordinate3();
  coords->point.setValues(0, 24, verts);
  tcoord.setValue(0.0, 0.0, 1.0);
  verts[0] = tcoord;
  verts[1] = tcoord;
  verts[2] = tcoord;
  verts[3] = tcoord;
  tcoord.setValue(1.0, 0.0, 0.0);
  verts[4] = tcoord;
  verts[5] = tcoord;
  verts[6] = tcoord;
  verts[7] = tcoord;
  tcoord.setValue(0.0, 0.0, -1.0);
  verts[8] = tcoord;
  verts[9] = tcoord;
  verts[10] = tcoord;
  verts[11] = tcoord;
  tcoord.setValue(-1.0, 0.0, 0.0);
  verts[12] = tcoord;
  verts[13] = tcoord;
  verts[14] = tcoord;
  verts[15] = tcoord;
  tcoord.setValue(0.0, -1.0, 0.0);
  verts[16] = tcoord;
  verts[17] = tcoord;
  verts[18] = tcoord;
  verts[19] = tcoord;
  tcoord.setValue(0.0, 1.0, 0.0);
  verts[20] = tcoord;
  verts[21] = tcoord;
  verts[22] = tcoord;
  verts[23] = tcoord;
  normals = new SoNormal();
  normals->vector.setValues(0, 24, verts);
  delete [] verts;
  
  indices = new int32_t[30+60+32];
  ind = indices;
  for (i=0; i<6; i++) {
    *ind++ = i*4;
    *ind++ = i*4+1;
    *ind++ = i*4+2;
    *ind++ = i*4+3;
    *ind++ = -1;
  }
  *ind++ = 13;  *ind++ = 12;  *ind++ = 16;  *ind++ = 19;  *ind++ = -1;
  *ind++ = 18;  *ind++ = 17;  *ind++ =  5;  *ind++ =  4;  *ind++ = -1;
  *ind++ =  7;  *ind++ =  6;  *ind++ = 22;  *ind++ = 21;  *ind++ = -1;
  *ind++ = 15;  *ind++ = 14;  *ind++ = 20;  *ind++ = 23;  *ind++ = -1;
  *ind++ = 19;  *ind++ = 18;  *ind++ =  1;  *ind++ =  0;  *ind++ = -1;
  *ind++ =  4;  *ind++ =  7;  *ind++ =  2;  *ind++ =  1;  *ind++ = -1;
  *ind++ =  3;  *ind++ =  2;  *ind++ = 21;  *ind++ = 20;  *ind++ = -1;
  *ind++ =  0;  *ind++ =  3;  *ind++ = 14;  *ind++ = 13;  *ind++ = -1;
  *ind++ = 17;  *ind++ = 16;  *ind++ =  9;  *ind++ =  8;  *ind++ = -1;
  *ind++ =  6;  *ind++ =  5;  *ind++ =  8;  *ind++ = 11;  *ind++ = -1;
  *ind++ = 11;  *ind++ = 10;  *ind++ = 23;  *ind++ = 22;  *ind++ = -1;
  *ind++ = 10;  *ind++ =  9;  *ind++ = 12;  *ind++ = 15;  *ind++ = -1;
  
  *ind++ =  0;  *ind++ = 13;  *ind++ = 19;  *ind++ = -1;
  *ind++ =  1;  *ind++ = 18;  *ind++ =  4;  *ind++ = -1;
  *ind++ =  2;  *ind++ =  7;  *ind++ = 21;  *ind++ = -1;
  *ind++ =  3;  *ind++ = 20;  *ind++ = 14;  *ind++ = -1;
  *ind++ =  9;  *ind++ = 16;  *ind++ = 12;  *ind++ = -1;
  *ind++ =  8;  *ind++ =  5;  *ind++ = 17;  *ind++ = -1;
  *ind++ = 11;  *ind++ = 22;  *ind++ =  6;  *ind++ = -1;
  *ind++ = 10;  *ind++ = 15;  *ind++ = 23;  *ind++ = -1;
  
  faces = new SoIndexedFaceSet();
  faces->coordIndex.setValues(0, 30+60+32, indices);
  delete [] indices;
  
  block->addChild(coords);
  block->addChild(normals);
  block->addChild(faces);
}

