/*
 * Copyright 1991-1995, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
 */
/*
 _______________________________________________________________________
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 |
 |
 |   main ()
 |
 |   Author	: Dave Immel
 |
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 _______________________________________________________________________
 */

#if defined(__linux)
#  include <time.h>
#endif
#include <math.h>
#include <Inventor/Xt/SoXt.h>
#include "TsField.h"

#define  FIELD_RESOLUTION   4

/*
 _______________________________________________________________________
 |
 |   Synopsis:
 |	main()
 |
 |   Description:
 |	Initialize the game and enter the Xt main loop.
 |
 _______________________________________________________________________
 */

int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget appWindow = SoXt::init(argv[0]);
  if (appWindow == NULL) 
    exit(1);

  //
  // Initialize a random number generator to be used in selecting the
  // next piece and orientation.
  //
  long tvec;
  time(&tvec);
  srand48(tvec);

  // Build the layout of the game.
  TsField *field = new TsField(FIELD_RESOLUTION, appWindow);
  field->setTitle("Drop");
  field->initGame();
  field->show();

  // Enter the Xt event loop
  SoXt::show(appWindow);
  SoXt::mainLoop();

  SoXt::finish();
  return 0;
}

