/*+-------------------------------------------------------------------
  |
  |  File:      DEFINES.H
  |  Voxelator example program.
  |  Copyright (C) 1996 Hewlett-Packard Co.
  |
  |  This source file is an example application implementation and
  |  may be used as is, modified and/or incorporated into user
  |  applications.  In any case this copyright statement should be
  |  left intact.
  |
  |  Description:   Contains all of the definitions and globals for
  |                 reading volume datasets.
  |
  +-------------------------------------------------------------------*/

#ifndef DEFINES_H
#define DEFINES_H

/*+-------------------------------------------------------------------
  |
  |  Enumerated type definitions
  |
  +-------------------------------------------------------------------*/

/*----- classification methods -----*/
typedef enum {
  LEVOY,
  THRESHOLD,
  LINEAR,
  EXPONENTIAL,
  INPUT_TABLE
} C_Classification;

/*----- interpolation methods -----*/
typedef enum {
  NEAREST,
  TRILINEAR,
  TRICUBIC,
  ADAPTIVE
} C_Interp_method;

/*----- gradient calculation -----*/
typedef enum {
  SOBEL,
  CENTRAL_DIFFS,
  INTERMEDIATE_DIFFS,
  BENTUM
} C_Gradient_method;

/*----- compositing method -----*/
typedef enum {
  BACK_TO_FRONT,
  FRONT_TO_BACK,
  MAXIMUM_VALUE,
  MINIMUM_VALUE,
  VOLUME_RESAMPLING,
  RAY_SUM,
  ISO_SURFACE
} C_Composite_method;

/*----- structure definitions -----*/
typedef struct {
  float red;
  float green;
  float blue;
} C_RGBtuple;

typedef struct {
  float x;
  float y;
  float z;
} C_FloatTuple;

typedef struct {
  int x;
  int y;
  int z;
} C_IntTuple;

typedef struct {
  float ambient_coeff;
  float specular_coeff;
  float specular_power;
  float reflective_coeff;
  C_RGBtuple ambient_color;
  C_RGBtuple object_color;
} C_ShadingParams;

typedef struct {
  C_IntTuple min;
  C_IntTuple max;
} Volume_dimensions;

/*+-------------------------------------------------------------------
  |
  |  Constant definitions
  |
  +-------------------------------------------------------------------*/
#define C_VR_MAGIC_NUMBER_OLD           192837465
#define C_VR_MAGIC_NUMBER               192837466
#define C_MANUFACTURER_STRING_LENGTH    20
#define C_ORIG_FILENAME_STRING_LENGTH   128 

/*+-------------------------------------------------------------------
  |
  |  Global variables
  |
  +-------------------------------------------------------------------*/

extern int         _MagicNumber;
extern int         _HeaderLength;

extern C_IntTuple  _VolumeDimensions;  /* size of volume   */
extern int         _PixelDepth;
extern GLenum      _PixelFormat;       /* GL format */
extern GLenum      _PixelType;         /* GL type */
extern int         _IndexBits;         /* number of "object" index bits */
                                       /* in each pixel                 */

extern float       _ScaleX;            /* base scale factors */
extern float       _ScaleY;
extern float       _ScaleZ;

extern float       _RotX;              /* base rotation */
extern float       _RotY;
extern float       _RotZ;

extern char        _Manufacturer[C_MANUFACTURER_STRING_LENGTH];
extern char        _OriginalFileName[C_ORIG_FILENAME_STRING_LENGTH];

extern int         _VolumeName;

#endif  /* DEMODEFS_H */


