#include <DialogViz/SoDialogVizAll.h>
#include <DialogViz/dialog/SoDialogViz.h>
#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoGradientBackground.h>

#include "SoAlgebraicArrow.h"


int
main ( int /*argc*/, char **argv )
{
  SoWidget window = SoXt::init(argv[0]);
  SoDialogViz::init();

  SoAlgebraicArrow::initClass();

  {
    SoInput input;
    input.openFile("$OIVHOME/examples/source/Inventor/Features/AlgebraicShape/CustomAlgebraicShape/CustomAlgebraicShape.iv");
    SoRef<SoSeparator> iv = SoDB::readAll(&input);

    SoTopLevelDialog* gui = static_cast<SoTopLevelDialog*>(iv->getByName("GUI"));
    gui->buildDialog(window, true);

    SoAlgebraicArrow* arrow = new SoAlgebraicArrow;

    SoDialogRealSlider* slider = static_cast<SoDialogRealSlider*>(iv->getByName("LENGTH"));
    arrow->length.connectFrom(&slider->value);

    slider = static_cast<SoDialogRealSlider*>(iv->getByName("CONE_RADIUS"));
    arrow->coneRadius.connectFrom(&slider->value);

    slider = static_cast<SoDialogRealSlider*>(iv->getByName("CYLINDER_RADIUS"));
    arrow->cylinderRadius.connectFrom(&slider->value);

    slider = static_cast<SoDialogRealSlider*>(iv->getByName("ARROW_HEAD"));
    arrow->arrowhead.connectFrom(&slider->value);

    SoSeparator* scene = static_cast<SoSeparator*>(iv->getByName("SCENE"));
    scene->addChild(new SoGradientBackground);
    scene->addChild(arrow);

    SoWidget viewerWidget =  static_cast<SoDialogCustom*>(iv->getByName("VIEWER"))->getWidget();
    SoXtExaminerViewer* viewer = new SoXtExaminerViewer(viewerWidget);
    viewer->setSceneGraph(scene);
    viewer->show();
    viewer->viewAll();

    SoXt::show(window);
    SoXt::mainLoop();

    delete viewer;
  }

  SoAlgebraicArrow::exitClass();

  SoDialogViz::finish();
  SoXt::finish();

  return EXIT_SUCCESS; 
}
