#ifndef SO_ALGEBRAIC_ARROW_H
#define SO_ALGEBRAIC_ARROW_H

#include <Inventor/nodes/SoAlgebraicShape.h>
#include <Inventor/fields/SoSFFloat.h>

/**
 * @brief Custom algebraic shape for arrow
 *
 * This class inherits SoAlgebraicShape with a custom shader for ray/shape intersection.
 * 
 */
class SoAlgebraicArrow : public SoAlgebraicShape
{
  SO_NODE_HEADER(SoAlgebraicArrow);

public:

  /**
   * @brief Length value.
   */
  SoSFFloat length;

  /**
   * @brief Size of the cone radius.
   */
  SoSFFloat coneRadius;

  /**
   * @brief Size of the cylinder radius.
   */
  SoSFFloat cylinderRadius;

  /**
   * @brief Percentage of the length of the shape to define the length of the arrowhead.
   */
  SoSFFloat arrowhead;

  /**
   * @brief Default constructor.
   */
  SoAlgebraicArrow ();

  /**
   * @brief Destructor.
   */
  virtual ~SoAlgebraicArrow () {}

protected:

  /**
   * @brief Compute the bounding box of the shape.
   * @param box the bounding box
   * @param center the center of the bbox
   */
  virtual void computeBBox ( SbBox3f &box, SbVec3f &center );


SoEXTENDER public:

  /**
   * @brief Specialized ray pick action.
   */
  virtual void rayPick ( SoRayPickAction *action );
  
private:

  //@{
  /**
  * @brief Utils.
  */
  bool rayPickCylinder(SbLine ray, SbVec3f& p);

  // Compute intersection between ray and cone.
  // ray should be expressed in space: Origin is top of cone. Y is along cone axis:
  //       O x-----> x
  //        /|\
  //       / | \
  //      /  v Y\
  //     /       \
  //    /_________\
  //
  bool rayPickCone( SbLine ray, SbVec3f& p);

  void backToOriginalFrame (SbVec3f& point, const SbVec3f translation) const; 
  SbLine changeFrame( SbLine ray, const SbVec3f translation) const; 
  //@}

SoINTERNAL public:

  //@{
  /**
   * @brief Registration.
   */
  static void initClass ();
  static void exitClass ();
  //@}
};



#endif
