#include <DialogViz/SoDialogVizAll.h>
#include <DialogViz/dialog/SoDialogViz.h>
#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoAlgebraicShape.h>
#include <Inventor/nodes/SoAlgebraicSphere.h>
#include <Inventor/nodes/SoTexture2.h>
#include <Inventor/nodes/SoTextureUnit.h>
#include <Inventor/nodes/SoGradientBackground.h>
#include <Inventor/nodes/SoMaterial.h>


int
main ( int /*argc*/, char **argv )
{
  SoWidget window = SoXt::init(argv[0]);
  SoDialogViz::init();

  {
    // Texture initialization
    SoTextureUnit* texUnit = new SoTextureUnit;
    texUnit->unit.setValue(0);

    SoTexture2* tex = new SoTexture2;
    tex->filename = "$OIVHOME/examples/source/Inventor/Features/AlgebraicShape/CustomComputeColor/textures/noise.png";

    // Create AlgebraicSphere with custom slot COMPUTE_COLOR
    SoAlgebraicSphere* sphere = new SoAlgebraicSphere;

    // Explicitly specify that generated fragment color is transparent
    sphere->generateTransparency = true;

    // Create shader for slot
    SoFragmentShader* frag = new SoFragmentShader;
    frag->sourceProgram = "$OIVHOME/examples/source/Inventor/Features/AlgebraicShape/CustomComputeColor/shaders/CustomComputeColor_frag.glsl";
    frag->addShaderParameter1i("noiseTex", 0);

    // Fill COMPUTE_COLOR slot with custom shader
    sphere->shaderSlots.set1Value(SoAlgebraicShape::COMPUTE_COLOR, frag);

    // Create scene graph
    SoSeparator* sep = new SoSeparator;
    sep->addChild(new SoGradientBackground);
    sep->addChild(texUnit);
    sep->addChild(tex);
    sep->addChild(sphere);

    // Create viewer
    SoXtExaminerViewer* viewer = new SoXtExaminerViewer(window);
    viewer->setTransparencyType(SoGLRenderAction::SORTED_PIXEL);
    viewer->setSceneGraph(sep);
    viewer->show();
    viewer->viewAll();

    SoXt::show(window);
    SoXt::mainLoop();

    delete viewer;
  }

  SoDialogViz::finish();
  SoXt::finish();

  return EXIT_SUCCESS;
}
