#include <Inventor/SoInput.h>
#include <Inventor/SoDB.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoEdgeFlag.h>
#include <Inventor/nodes/SoVertexFlag.h>
#include <Inventor/nodes/SoBevelProperty.h>
#include <Inventor/elements/SoEdgeFlagElement.h>
#include <Inventor/elements/SoVertexFlagElement.h>
#include <Inventor/elements/SoBevelPropertyElement.h>
#include <Inventor/actions/SoBevelAction.h>
#include <Inventor/nodes/SoShapeHints.h>
#include <Inventor/actions/SoWriteAction.h>
#include <Inventor/nodes/SoComplexity.h>



int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL) 
    exit(1);

  SoInput *input = new SoInput();
  
  if (!input->openFile("$OIVHOME/examples/data/Inventor/BevelAction/cube.iv"))
    exit(0);

  SoSeparator *root = SoDB::readAll(input);
  root->ref();

  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setBackgroundColor(SbColor(1.0, 1.0, 1.0));

  SoSeparator *result1 = new SoSeparator();
  result1->ref();
  SoComplexity *myComplexity = new SoComplexity();
  myComplexity->value = 1.f;
  result1->addChild(myComplexity);

  SoBevelProperty *prop = new SoBevelProperty();
  prop->radius.setValue(0.2f);
  result1->addChild(prop);
  result1->addChild(root);
  
  root->unref();

  SoBevelAction baction;
  baction.apply(result1);
  SoGroup *result2 = baction.getSceneGraph();
  result2->ref();

  myViewer->setSceneGraph(result2);
  myViewer->setTitle("BevelAction");
  myViewer->show();
  myViewer->viewAll();

  SoWriteAction myAction;
  myAction.getOutput()->openFile("./bevel.iv");
  myAction.apply(result2);
  myAction.getOutput()->closeFile();

  SoXt::show(myWindow);
  SoXt::mainLoop();

  result1->unref();
  result2->unref();
  delete myViewer;
  delete input;
  SoXt::finish();

  return 0;
}


