
#include <Inventor/SoDB.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <Inventor/devices/SoGpuBufferObject.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoBufferedShape.h>
#include <Inventor/nodes/SoDrawStyle.h>

//------------------------------------------------------------------------------

#define PRIMITIVE_RESTART_VALUE -3

// Uncoment this line to see the result of using primitive restart
//#define NO_PRIMITIVE_RESTART

int 
main( int , char** )
{
  // We init OIV
  Widget mainWindow = SoXt::init( "PrimitivesRestart" );
  if (mainWindow == NULL)
    exit (1);

  
  SoXtExaminerViewer* examinerViewer = new SoXtExaminerViewer( mainWindow );

  SoBufferedShape* bufferedShape = new SoBufferedShape;

  // Assembly
  SoSeparator* root = new SoSeparator;
  root->ref();

  SoSeparator* scene = new SoSeparator;
  root->addChild(scene);

  SoDrawStyle* drawStyle = new SoDrawStyle();
  drawStyle->style = SoDrawStyle::LINES;
  scene->addChild(drawStyle);
  
  // Build and initialize the Inventor render area widget
  {
    examinerViewer->setDecoration( TRUE );
    examinerViewer->setFeedbackVisibility( FALSE );
    examinerViewer->setSceneGraph( root );
    examinerViewer->setTitle( "PrimitiveRestart" );
    examinerViewer->setHeadlight( true );

    examinerViewer->show();

    // Ok here we go...
    SoXt::show( mainWindow );
  }

  examinerViewer->bindNormalContext();
  {
    bool primitiveRestartAvailable = false;

#if !defined(NO_PRIMITIVE_RESTART)
    if (SoShape::isPrimitiveRestartAvailable() == FALSE)
      SoDebugError::post("PrimitiveRestart", "Primitive restart is not available on the current system");
    else
      primitiveRestartAvailable = true;
#endif

    scene->addChild(bufferedShape);

    SoGpuBufferObject* normalsBuffer = new SoGpuBufferObject(SoGpuBufferObject::DYNAMIC);
    normalsBuffer->setSize( 2 * 50 * 2 * 3 * sizeof(float));

    float* nptr = (float*)normalsBuffer->map(SoBufferObject::SET);

    SoGpuBufferObject* colorsBuffer = new SoGpuBufferObject(SoGpuBufferObject::DYNAMIC);
    colorsBuffer->setSize( 2 * 50 * 2 * 3 * sizeof(float));

    float* cptr = (float*)colorsBuffer->map(SoBufferObject::SET);

    SoGpuBufferObject* verticesBuffer = new SoGpuBufferObject(SoGpuBufferObject::DYNAMIC);

    int idx = 0, nidx = 0, cidx = 0;

    verticesBuffer->setSize( 2 * 50 * 2 * 3 * sizeof(float));

    float* ptr = (float*)verticesBuffer->map(SoBufferObject::SET);
    for (int i = 0; i < 50; i++)
    {
      ptr[idx++] = (float)i; ptr[idx++] = 5.0f; ptr[idx++] = 0.0f;
      ptr[idx++] = (float)i; ptr[idx++] = 0.0f; ptr[idx++] = 0.0f;
      nptr[nidx++] = 0.f; nptr[nidx++] = 0.f; nptr[nidx++] = 1.f;
      nptr[nidx++] = 0.f; nptr[nidx++] = 0.f; nptr[nidx++] = 1.f;
      cptr[cidx++] = 1.f; cptr[cidx++] = 0.f; cptr[cidx++] = 0.f;
      cptr[cidx++] = 0.f; cptr[cidx++] = 1.f; cptr[cidx++] = 0.f;
    }

    for (int i = 0; i < 50; i++)
    {
      ptr[idx++] = (float)i+100.f; ptr[idx++] = 30.0f; ptr[idx++] = 0.0f;
      ptr[idx++] = (float)i+100.f; ptr[idx++] = 25.0f; ptr[idx++] = 0.0f;
      nptr[nidx++] = 0.f; nptr[nidx++] = 0.f; nptr[nidx++] = 1.f;
      nptr[nidx++] = 0.f; nptr[nidx++] = 0.f; nptr[nidx++] = 1.f;
      cptr[cidx++] = 0.f; cptr[cidx++] = 0.f; cptr[cidx++] = 1.f;
      cptr[cidx++] = 1.f; cptr[cidx++] = 1.f; cptr[cidx++] = 0.f;
    }
    verticesBuffer->unmap();  
    normalsBuffer->unmap();  
    colorsBuffer->unmap();

    SoGpuBufferObject* indicesBuffer = new SoGpuBufferObject(SoGpuBufferObject::DYNAMIC);
    
    indicesBuffer->setSize( (2 * 50 * 2 + 1) * sizeof(unsigned int) );
    unsigned int* iptr = (unsigned int*)indicesBuffer->map(SoBufferObject::SET);
    idx = 0;

    for (int i = 0; i < 100; i++)
      iptr[idx++] = i;

    int startIdx = idx;

    // Let's set the primitive restart value
    if (primitiveRestartAvailable)
      iptr[idx++] = (unsigned int)PRIMITIVE_RESTART_VALUE;

    int secondShapePosition = idx;
        
    for (int i = 0; i < 100; i++)
      iptr[idx++] = startIdx + i;    

    indicesBuffer->unmap();

    bufferedShape->shapeType = SoBufferedShape::TRIANGLE_STRIP;

    bufferedShape->vertexBuffer = verticesBuffer;
    bufferedShape->normalBuffer = normalsBuffer;
    bufferedShape->colorBuffer = colorsBuffer;
    bufferedShape->indexBuffer = indicesBuffer;

    if (primitiveRestartAvailable)
    {
      bufferedShape->primitiveRestartEnabled = TRUE;
      bufferedShape->primitiveRestartValue = PRIMITIVE_RESTART_VALUE;
    }

#if !defined(NO_PRIMITIVE_RESTART)
    if (primitiveRestartAvailable)
      bufferedShape->numVertices.set1Value(0, idx); 
    // If the primitive restart is not available use to draw calls.
    else
    {
      bufferedShape->numVertices.set1Value(0, secondShapePosition); 
      bufferedShape->numVertices.set1Value(1, idx - secondShapePosition); 
    }
#else
    bufferedShape->numVertices.set1Value(0, idx); 
#endif
  }

  examinerViewer->unbindNormalContext();
  
  examinerViewer->getCamera()->viewAll( root, examinerViewer->getViewportRegion() );

  SoXt::mainLoop();

  delete examinerViewer;

  SoXt::finish();

  return 0;
}

//------------------------------------------------------------------------------

