#if !defined GEOMETRY_H
#define GEOMETRY_H

class SoBufferedShape;

/** 
 * This function creates a bumped geometry from a bump image.
 * The resulting buffer shape contains one vertex for each pixel in the bump image.
 * For each vertex the normal is computed and the color comes from the color image.
 *
 * The buffered shape uses VBOs for the geometry but the buffers can be switched to CPU mode.
 *
 * @param bumpFile The image which contains the bump information in a 8bits image file.
 * @param colorMap The colormap used for the colors computation.
 * 
 * @return The computed buffered geometry from the two images.
 */
SoBufferedShape* buildGeometry( std::string bumpFile, std::string colorMap, float zScale, 
                               bool computeNormals );

bool updateGeometry( SoBufferedShape* bufferedShape, float zScale, bool computeNormals );


#endif //GEOMETRY_H

