#include <Inventor/devices/SoGpuBufferObject.h>

#include <Inventor/nodes/SoBufferedShape.h>
#include <Inventor/nodes/SoFaceSet.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoShaderProgram.h>
#include <Inventor/nodes/SoVertexShader.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

// This define is used to show how the vertex data were handle before the introduction
// of the BufferObjects support in SoVertexShaderParameter.
// #define USE_OLD_FASHION

// This define is used to show that the new node works also with an SoVertexProperty
//#define USE_VERTEX_PROPERTY


const char* g_vertexShaderStr =
  "#version 410 core\n"
  "//!oiv_include <Inventor/oivShapeAttribute.h>\n"
  "//!oiv_include <Inventor/oivShaderState.h>\n"
  "//!oiv_include <Inventor/oivShaderVariables.h>\n"
  "\n"
  "in vec4 color;\n"
  "\n"
  "void main()\n"
  "{\n"
  "  OivSetFrontColor(color);\n"
  "  gl_Position = OivModelViewProjectionMatrix() * OivVertexPosition();\n"
  "}\n";


int
main(int, char **argv)
{
  float* ptr = NULL;
  int idx = 0;

  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL)
    exit(1);

  // 1 - Set up the viewer
  //     We setup the viewer first because we need the OGL context for
  //     the buffer objects.
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setTitle("Examiner Viewer");
  myViewer->show();
  SoXt::show(myWindow);
  
  // 2 - The root of our scene-graph
  SoSeparator *root = new SoSeparator;
  root->ref();

  // 3 - Load the shader and attach some vertices data
  SoVertexShader* vertexShader = new SoVertexShader;
  vertexShader->sourceType = SoVertexShader::GLSL_PROGRAM;
  vertexShader->sourceProgram = g_vertexShaderStr;

  SoShaderProgram* shaderProgram = new SoShaderProgram;
  shaderProgram->shaderObject.set1Value(0, vertexShader);
  
  // - Bind the viewer context, we need it for the Gpu buffer objects
  myViewer->bindNormalContext();

  // 4 - Let's create the shape and add some vertices
#if defined(USE_VERTEX_PROPERTY)
  SoFaceSet* shape = new SoFaceSet();
  SoVertexProperty* vp = new SoVertexProperty();
  vp->vertex.set1Value(0, SbVec3f(0.0F, 1.0F, 0.0F));
  vp->vertex.set1Value(1, SbVec3f(1.0F, 1.0F, 0.0F));
  vp->vertex.set1Value(2, SbVec3f(0.0F, 0.0F, 0.0F));
  vp->vertex.set1Value(3, SbVec3f(1.0F, 1.0F, 0.0F));
  vp->vertex.set1Value(4, SbVec3f(1.0F, 0.0F, 0.0F));
  vp->vertex.set1Value(5, SbVec3f(0.0F, 0.0F, 0.0F));
  shape->vertexProperty = vp;
  shape->numVertices.set1Value(0, 3);
  shape->numVertices.set1Value(1, 3);
#else
  SoBufferedShape* shape = new SoBufferedShape();
  
  SoGpuBufferObject* verticesBuffer = new SoGpuBufferObject(SoGpuBufferObject::DYNAMIC);

  //   - Add two triangles
  verticesBuffer->setSize(2 * 3 * 3 * sizeof(float));
  shape->vertexBuffer = verticesBuffer;
  shape->numVertices.set1Value(0, 6);

  //   - Put some data in the vertices buffer
  idx = 0;
  ptr = (float*)verticesBuffer->map(SoGpuBufferObject::SET);
  ptr[idx++] = 0.0F; ptr[idx++] = 1.0F;  ptr[idx++] = 0.0F;
  ptr[idx++] = 1.0F; ptr[idx++] = 1.0F;  ptr[idx++] = 0.0F;
  ptr[idx++] = 0.0F; ptr[idx++] = 0.0F;  ptr[idx++] = 0.0F;

  ptr[idx++] = 1.0F; ptr[idx++] = 1.0F;  ptr[idx++] = 0.0F;
  ptr[idx++] = 1.0F; ptr[idx++] = 0.0F;  ptr[idx++] = 0.0F;
  ptr[idx++] = 0.0F; ptr[idx++] = 0.0F;  ptr[idx++] = 0.0F;
  verticesBuffer->unmap();
#endif

  // 5 - Use a SoVertexShaderParameter to set the colors
#if defined(USE_OLD_FASHION)
  SoVertexShaderParameter4f* colorsParameter = new SoVertexShaderParameter4f();
  colorsParameter->value.set1Value(0, 1.0F, 0.0F, 0.0F, 1.0F);
  colorsParameter->value.set1Value(1, 0.0F, 1.0F, 0.0F, 1.0F);
  colorsParameter->value.set1Value(2, 0.0F, 0.0F, 1.0F, 1.0F);
  colorsParameter->value.set1Value(3, 0.0F, 1.0F, 0.0F, 1.0F);
  colorsParameter->value.set1Value(4, 0.0F, 1.0F, 1.0F, 1.0F);
  colorsParameter->value.set1Value(5, 0.0F, 0.0F, 1.0F, 1.0F);
#else
  SoGpuBufferObject* colorsBuffer = new SoGpuBufferObject(SoGpuBufferObject::DYNAMIC);
  colorsBuffer->setSize(2 * 3 * 4 * sizeof(float));
  
  idx = 0;
  ptr = (float*)colorsBuffer->map(SoGpuBufferObject::SET);
  ptr[idx++] = 1.0F; ptr[idx++] = 0.0F;  ptr[idx++] = 0.0F; ptr[idx++] = 1.0F;
  ptr[idx++] = 0.0F; ptr[idx++] = 1.0F;  ptr[idx++] = 0.0F; ptr[idx++] = 1.0F;
  ptr[idx++] = 0.0F; ptr[idx++] = 0.0F;  ptr[idx++] = 1.0F; ptr[idx++] = 1.0F;

  ptr[idx++] = 0.0F; ptr[idx++] = 1.0F;  ptr[idx++] = 0.0F; ptr[idx++] = 1.0F;
  ptr[idx++] = 0.0F; ptr[idx++] = 1.0F;  ptr[idx++] = 1.0F; ptr[idx++] = 1.0F;
  ptr[idx++] = 0.0F; ptr[idx++] = 0.0F;  ptr[idx++] = 1.0F; ptr[idx++] = 1.0F;
  colorsBuffer->unmap();

  SoVertexShaderParameterBufferObject* colorsParameter = new SoVertexShaderParameterBufferObject();
  colorsParameter->value = colorsBuffer;
#endif

  colorsParameter->name = "color";
  
  myViewer->unbindNormalContext();
  

  root->addChild(colorsParameter);
  root->addChild(shaderProgram);
  root->addChild(shape);

  // 6 - Render ....
  myViewer->setSceneGraph(root);
  SoXt::mainLoop();

  root->unref();

  delete myViewer;

  SoXt::finish();
  return 0;
}



