#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/actions/SoGetBoundingBoxAction.h>
#include <Inventor/manips/SoClipPlaneManip.h>
#include <Inventor/nodes/SoWWWInline.h>

SoSeparator *
readFile(const char *filename)
{
  // Open the input file
  SoInput mySceneInput;
  if (!mySceneInput.openFile(filename)) {
    fprintf(stderr, "Cannot open file %s\n", filename);
    return NULL;
  }
  SoWWWInline::setReadAsSoFile(TRUE);

  // Read the whole file into the database
  SoSeparator *myGraph = SoDB::readAll(&mySceneInput);
  if (myGraph == NULL) {
    fprintf(stderr, "Problem reading file\n");
    return NULL;
  } 

  mySceneInput.closeFile();
  return myGraph;
}

int 
main(int argc, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);

  const char *filename = "$OIVHOME/data/models/slotMachine.iv";

  if (argc < 2) 
    printf("Usage : %s <file.iv>\n", argv[0]);
  if (argc >=2 ) 
    filename = argv[1];

  // Read the file
  SoSeparator *scene = readFile(filename);
  scene->ref();

  // Compute the bounding box of the scene graph.
  SoGetBoundingBoxAction bboxAction(SbViewportRegion(100, 100));
  bboxAction.apply(scene);
  
  // Inserting the manipulator at the center of the scene graph and in the plane YZ.
  SoClipPlaneManip *clipPlaneManip = new SoClipPlaneManip;
  clipPlaneManip->setValue(bboxAction.getBoundingBox(), SbVec3f(1, 0, 0), 0.1f);
  scene->insertChild(clipPlaneManip, 0);

  // Create a viewer
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);

  // attach and show viewer
  myViewer->setSceneGraph(scene);
  myViewer->setTitle("Clip Plane Manipulator");
  myViewer->show();
    
  // Loop forever
  SoXt::show(myWindow);
  SoXt::mainLoop();

  scene->unref();
  delete myViewer;
  SoXt::finish();

  return 0;
}


