#if !defined FILTERING_H
#define FILTERING_H

#include <Inventor/SbDataType.h>

class SoBufferObject;
class SoDeviceContext;
class SoAlgorithms;

class SoConvolution;
class SoConversion;
class SoArithmetic;
class SoConvolutionHandle;

class Filtering
{
public:

  /**
   * Default constructor.
   */

  Filtering( SoAlgorithms* algorithmsInterface );

  /**
   * Default destructor.
   */
  virtual ~Filtering();
  
  virtual void Sobel( SoBufferObject* inputBufferObject, 
              SbDataType::DataType inputBufferType,
              SoBufferObject* outputBufferObject, 
              SbDataType::DataType outputBufferType,
              int width,
              int height,
              float scale );

  virtual void Prewitt( SoBufferObject* inputBufferObject, 
                        SbDataType::DataType inputBufferType,
                        SoBufferObject* outputBufferObject, 
                        SbDataType::DataType outputBufferType,
                        int width,
                        int height,
                        float scale );

  virtual void Blur( SoBufferObject* inputBufferObject, 
              SbDataType::DataType inputBufferType,
              SoBufferObject* outputBufferObject, 
              SbDataType::DataType outputBufferType,
              int width,
              int height,
              int blurDepth );

  virtual SoBufferObject* createBuffer( int width, int height );

  virtual void CustomKernel( SoBufferObject* inputBufferObject, 
              SbDataType::DataType inputBufferType,
              SoBufferObject* outputBufferObject, 
              SbDataType::DataType outputBufferType,
              int width,
              int height,
              float* rowKernel,
              int rowKernelSize,
              float* columnKernel,
              int columnKernelSize,
              float scale,
              int iterations,
              int convolutionCenter );

  SbBool init();

protected:

  void updateBuffersSize( int width, int height );

  void edgeDetect( SoBufferObject* inputBufferObject, 
                   SbDataType::DataType inputBufferType,
                   SoBufferObject* outputBufferObject, 
                   SbDataType::DataType outputBufferType,
                   int width,
                   int height,
                   float scale,
                   float* kernel1,
                   float* kernel2,
                   float* kernel3 );

private:
  SoBufferObject* m_bufferFloats[2];
  SoBufferObject* m_inputBufferObject;
  SoBufferObject* m_outputBufferObject;

  SoDeviceContext* m_deviceContext;

  SoConvolution* m_convolutionAlgorithms;
  SoConversion* m_conversionAlgorithms;
  SoArithmetic* m_arithmeticAlgorithms;

  SoAlgorithms* m_algorithmsInterface;
};


//------------------------------------------------------------------------------


#endif //FILTERING_H


