#include <DialogViz/SoDialogVizAll.h>
#include <DialogViz/dialog/SoDialogViz.h>
#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoGradientBackground.h>
#include <Inventor/nodes/SoLightModel.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/nodes/SoGLCallback.h>
#include <Inventor/nodes/SoFile.h>
#include <Inventor/nodes/SoText2.h>
#include <Inventor/nodes/SoFont.h>

#include "CustomNodeOpenGLCore.h"
#include "CustomNodeOpenGLLegacy.h"
#include "CustomNodeGLCallback.h"

namespace helper
{
  // Helper function that creates a scene graph containing a custom node,
  // a custom shader if it uses one, and a text node describing it
  static SoSeparator*
  buildSubSceneGraph(SoNode* node, const char* message, SoShaderProgram* shader = NULL)
  {
    SoSeparator* sep = new SoSeparator;

    if (shader != NULL)
      sep->addChild(shader);

    sep->addChild(node);

    SoText2* text = new SoText2;
    text->string = message;
    text->justification = SoText2::CENTER;

    SoTransform* trans = new SoTransform;
    trans->translation.setValue(SbVec3f(0.f, -0.1f, 0.f));

    sep->addChild(trans);
    sep->addChild(text);
    return sep;
  }
}

int
main(int /*argc*/, char **argv)
{
  SoWidget window = SoXt::init(argv[0]);

  CustomNodeOpenGLCore::initClass();
  CustomNodeOpenGLLegacy::initClass();

  SoInput::addDirectoryFirst("$OIVHOME/examples/source/Inventor/Features/CustomNode/CustomNodeBunny");
  {
    // Create scene graph
    SoSeparator* sep = new SoSeparator;
    sep->addChild(new SoGradientBackground);
    sep->addChild(new SoLightModel);

    SoFont* font = new SoFont;
    font->size = 14;
    sep->addChild(font);

    SoTransform* transX = new SoTransform;
    transX->translation.setValue(SbVec3f(0.25f, 0.f, 0.f));

    SoTransform* transYBN = new SoTransform;
    transYBN->translation.setValue(SbVec3f(0.f, -0.25f, 0.f));

    SoTransform* transYBP = new SoTransform;
    transYBP->translation.setValue(SbVec3f(0.f, 0.25f, 0.f));

    // Inventor bunny
    {
      SoFile* file = new SoFile;
      file->name.setValue("Bunny.iv");

      sep->addChild(helper::buildSubSceneGraph(file, "Inventor"));
    }

    // Custom node OpenGL core bunny
    sep->addChild(transYBN);
    {
      SoSeparator* ssep = helper::buildSubSceneGraph(new CustomNodeOpenGLCore, "OpenGL core", CustomNodeOpenGLCore::getShaderProgram());
      sep->addChild(ssep);
    }

    // Custom node OpenGL legacy bunny
    sep->addChild(transX);
    {
      sep->addChild(helper::buildSubSceneGraph(new CustomNodeOpenGLLegacy, "OpenGL Legacy"));
    }

    // Custom SoGLCallback OpenGL legacy bunny
    sep->addChild(transYBP);
    {
      CustomNodeGLCallback* callback = new CustomNodeGLCallback;

      SoGLCallback* cb = new SoGLCallback;
      cb->setCallback(&CustomNodeGLCallback::callback, callback);

      sep->addChild(helper::buildSubSceneGraph(cb, "SoGLCallback"));
    }

    // Create viewer
    SoXtExaminerViewer* viewer = new SoXtExaminerViewer(window);
    viewer->setSceneGraph(sep);
    viewer->show();
    viewer->viewAll();

    SoXt::show(window);
    SoXt::mainLoop();

    delete viewer;
  }

  CustomNodeOpenGLCore::exitClass();
  CustomNodeOpenGLLegacy::exitClass();
  SoXt::finish();

  return EXIT_SUCCESS;
}
