#pragma once

#include <Inventor/actions/SoAction.h>
#include <Inventor/sys/SoGL.h>

/**
 * CustomNodeGLCallback
 *
 * @DESCRIPTION
 * This class uses a callback to show another way of making OpenGL calls.
 */
class CustomNodeGLCallback
{
public:

  /**
   * @brief Default constructor
   */
  CustomNodeGLCallback();

  /**
   * @brief Callback for SoGLCallback
   */
  static void callback(void* data, SoAction* action);

protected:

  // destructor
  ~CustomNodeGLCallback();

  // create OpenGL resources
  void initialize();

private:

  bool m_initialized;
  GLuint m_vertexBuffer;
  GLuint m_colorBuffer;
  GLuint m_normalBuffer;
};
