#pragma once

#include <Inventor/nodes/SoShape.h>
#include <Inventor/sys/SoGL.h>

/**
 * CustomNodeOpenGLLegacy
 *
 * @DESCRIPTION
 * This custom node renders a shape using OpenGL compatibility functions
 *
 * The initClass() method uses the flag OIV_OPENGL_COMPATIBILITY_RENDERING
 * to set up the right render mode.
 *
 * @SEE_ALSO
 * CustomNodeOpenGLCore
 */
class CustomNodeOpenGLLegacy : public SoShape
{
  SO_NODE_HEADER(CustomNodeOpenGLLegacy);

public:

  /**
   * Default constructor.
   */
  CustomNodeOpenGLLegacy();

  static void initClass();
  static void exitClass();

protected:

  // destructor
  virtual ~CustomNodeOpenGLLegacy ();

  // not implemented here
  void generatePrimitives(SoAction* /*action*/) {}

  // create OpenGL resources
  void initialize();

SoEXTENDER public:

  // Rendering stuff
  virtual void GLRender(SoGLRenderAction *action);

  // BBox computation
  virtual void computeBBox(SoAction *action, SbBox3f &box, SbVec3f &center);

private:

  bool m_initialized;
  GLuint m_vertexBuffer;
  GLuint m_colorBuffer;
  GLuint m_normalBuffer;
};
