#include "CustomNodeBase.h"

#include <Inventor/elements/SoLightModelElement.h>
#include <Inventor/actions/SoGLRenderAction.h>
#include <Inventor/actions/SoGetBoundingBoxAction.h>


////////////////////////////////////////////////////////////

SO_NODE_SOURCE(CustomNodeBase);

CustomNodeBase::CustomNodeBase()
{
  SO_NODE_CONSTRUCTOR(CustomNodeBase);
}

CustomNodeBase::~CustomNodeBase()
{
}

void
CustomNodeBase::setCustomNodeType(SoNode* node)
{
  m_internalGLNode = node;
}

void
CustomNodeBase::initClass()
{
  getClassRenderEngineMode().setRenderMode(SbRenderEngineMode::OIV_OPENINVENTOR_RENDERING);
  SO__NODE_INIT_CLASS(CustomNodeBase, "CustomNodeBase", SoNode);
}

void
CustomNodeBase::exitClass()
{
  SO__NODE_EXIT_CLASS(CustomNodeBase);
}

void
CustomNodeBase::generatePrimitives(SoAction* /*action*/)
{

}

void
CustomNodeBase::initialize()
{
}

void
CustomNodeBase::destroyResources()
{
}

void
CustomNodeBase::GLRender(SoGLRenderAction *action)
{
  SoState* state = action->getState();

  if (action->handleTransparency(TRUE))
    return;

  state->push();
  action->forwardTraversal(m_internalGLNode.ptr());
  state->pop();
}

void
CustomNodeBase::getBoundingBox(SoGetBoundingBoxAction *action)
{
  action->forwardTraversal(m_internalGLNode.ptr());
}
