#pragma once

#include <Inventor/actions/SoAction.h>
#include <Inventor/nodes/SoShaderProgram.h>
#include <Inventor/sys/SoGL.h>

/**
 * CustomNodeGLCallback
 *
 * @DESCRIPTION
 * This class uses a callback to show another way of making OpenGL calls.
 */
class CustomNodeGLCallback
{
public:

  /**
  * @brief Default constructor
  */
  CustomNodeGLCallback();

  /**
  * @brief Callback for SoGLCallback
  */
  static void callback(void* data, SoAction* action);

  // Method used to retrieve the shader program used with this custom node
  static SoShaderProgram* getShaderProgram();

protected:

  // destructor
  ~CustomNodeGLCallback();

  // create OpenGL resources
  void initialize();

  // destroy OpenGL resources
  void destroy();

private:

  bool m_initialized;
  GLuint m_vertexBuffer;
  GLuint m_colorBuffer;
  GLuint m_normalBuffer;
};
