#pragma once

#include <Inventor/nodes/SoShaderProgram.h>
#include <Inventor/nodes/SoShape.h>
#include <Inventor/sys/SoGL.h>

/**
 * CustomNodeOpenGLLegacy
 *
 * @DESCRIPTION
 * This custom node renders a shape using OpenGL compatibility functions
 *
 * The initClass() method uses the flag OIV_OPENGL_COMPATIBILITY_RENDERING
 * to set up the right render mode.
 *
 * @SEE_ALSO
 * CustomNodeOpenGLCore
 */
class CustomNodeOpenGLLegacy : public SoShape
{
  SO_NODE_HEADER(CustomNodeOpenGLLegacy);

public:

  /**
  * Default constructor.
  */
  CustomNodeOpenGLLegacy();

  static void initClass();
  static void exitClass();

  // Method used to retrieve the shader program used with this custom node
  static SoShaderProgram* getShaderProgram();

protected:

  // destructor
  virtual ~CustomNodeOpenGLLegacy();

  void generatePrimitives(SoAction* action);

  // create OpenGL resources
  void initialize();

  // destroy OpenGL resources
  void destroyResources();

SoEXTENDER public:

  // Rendering stuff
  virtual void GLRender(SoGLRenderAction *action);

  // BBox computation
  virtual void computeBBox(SoAction *action, SbBox3f &box, SbVec3f &center);

private:

  bool m_initialized;
  GLuint m_vertexBuffer;
  GLuint m_colorBuffer;
  GLuint m_normalBuffer;
};
