#include <DialogViz/SoDialogVizAll.h>
#include <DialogViz/dialog/SoDialogViz.h>
#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoGradientBackground.h>
#include <Inventor/nodes/SoLightModel.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/nodes/SoGLCallback.h>
#include <Inventor/nodes/SoFile.h>
#include <Inventor/nodes/SoText2.h>
#include <Inventor/nodes/SoFont.h>

#include "CustomNodeOpenGLCore.h"
#include "CustomNodeOpenGLLegacy.h"
#include "CustomNodeOIV.h"
#include "CustomNodeBase.h"
#include "CustomNodeGLCallback.h"

namespace helper
{
  // Helper function that creates a scene graph containing a custom node,
  // a custom shader if it uses one, and a text node describing it
  static SoSeparator*
  buildSubSceneGraph(SoNode* node, const char* message, SoShaderProgram* shader = NULL)
  {
    SoSeparator* sep = new SoSeparator;

    SoText2* text = new SoText2;
    text->string = message;
    text->justification = SoText2::CENTER;

    SoTransform* trans = new SoTransform;
    trans->translation.setValue(SbVec3f(0.f, -1.5f, 0.f));

    sep->addChild(trans);
    sep->addChild(text);

    SoTransform* invTrans = new SoTransform;
    invTrans->translation.setValue(SbVec3f(0.f, 1.5f, 0.f));

    sep->addChild(invTrans);

    if(shader != NULL)
      sep->addChild(shader);

    sep->addChild(node);

    return sep;
  }
}

int
main(int /*argc*/, char **argv)
{
  SoWidget window = SoXt::init(argv[0]);

  CustomNodeBase::initClass();
  CustomNodeOpenGLCore::initClass();
  CustomNodeOpenGLLegacy::initClass();
  Pyramid::initClass();

  SoInput::addDirectoryFirst("$OIVHOME/examples/source/Inventor/Features/CustomNode/CustomNodePyramid");
  {
    // Create scene graph
    SoSeparator* sep = new SoSeparator;
    sep->addChild(new SoGradientBackground);
    sep->addChild(new SoLightModel);

    SoFont* font = new SoFont;
    font->size = 14;
    sep->addChild(font);

    SoTransform* transX = new SoTransform;
    transX->translation.setValue(SbVec3f(3.0f, 0.f, 0.f));

    SoTransform* transYBN = new SoTransform;
    transYBN->translation.setValue(SbVec3f(0.f, -3.0f, 0.f));

    SoTransform* transYBP = new SoTransform;
    transYBP->translation.setValue(SbVec3f(0.f, 3.0f, 0.f));

    // Inventor pyramid
    {
      SoFile* file = new SoFile;
      file->name.setValue("pyramid.iv");
      sep->addChild(helper::buildSubSceneGraph(file, "Inventor"));
    }
    
    // Custom node OpenGL core pyramid
    SoRef<CustomNodeBase> customNodeBaseCore = new CustomNodeBase;
    sep->addChild(transYBN);
    {
      customNodeBaseCore->setCustomNodeType(new CustomNodeOpenGLCore);
      SoSeparator* ssep = helper::buildSubSceneGraph(customNodeBaseCore.ptr(), "OpenGL core", CustomNodeOpenGLCore::getShaderProgram());
      sep->addChild(ssep);
    }
    
    // Custom node OpenGL legacy pyramid
    SoRef<CustomNodeBase> customNodeBaseLegacy = new CustomNodeBase;
    sep->addChild(transX);
    {
      customNodeBaseLegacy->setCustomNodeType(new CustomNodeOpenGLLegacy);
      SoSeparator* ssep = helper::buildSubSceneGraph(customNodeBaseLegacy.ptr(), "OpenGL legacy", CustomNodeOpenGLLegacy::getShaderProgram());
      sep->addChild(ssep);
    }
    
    // Custom SoGLCallback OpenGL legacy pyramid
    SoRef<CustomNodeBase> customNodeBaseCallback = new CustomNodeBase;
    sep->addChild(transYBP);
    {
      CustomNodeGLCallback* callback = new CustomNodeGLCallback;
      SoGLCallback* cb = new SoGLCallback;
      cb->setCallback(&CustomNodeGLCallback::callback, callback);
      customNodeBaseCallback->setCustomNodeType(cb);
      SoSeparator* ssep = helper::buildSubSceneGraph(customNodeBaseCallback.ptr(), "SoGLCallback", CustomNodeGLCallback::getShaderProgram());
      sep->addChild(ssep);
    }

    // Create viewer
    SoXtExaminerViewer* viewer = new SoXtExaminerViewer(window);
    viewer->setTransparencyType(SoGLRenderAction::SORTED_PIXEL);
    viewer->setSceneGraph(sep);
    viewer->show();
    viewer->viewAll();

    SoXt::show(window);
    SoXt::mainLoop();

    delete viewer;
  }

  Pyramid::exitClass();
  CustomNodeOpenGLCore::exitClass();
  CustomNodeOpenGLLegacy::exitClass();
  CustomNodeBase::exitClass();
  SoXt::finish();

  return EXIT_SUCCESS;
}
