#version 410 compatibility

//!oiv_include <Inventor/oivShaderState.h>

layout(location = 0) in vec3 vertexPosition;
layout(location = 1) in vec4 vertexColor;
layout(location = 2) in vec3 vertexNormal;

out vec3 normal;
out vec4 color;

void
main ()
{
  normal = OivNormalMatrix() * vertexNormal;
  color = vertexColor;
  gl_Position = OivModelViewProjectionMatrix() * vec4(vertexPosition, 1.0);
}
