#version 410 compatibility

//!oiv_include <Inventor/oivDepthPeeling_frag.h>

in vec3 normal;
in vec4 color;

void
main ()
{
  if (OivDepthPeel(gl_FragCoord.xyz))
  {
    vec3 l = normalize(gl_LightSource[0].position.xyz);
    vec3 n = normalize(normal);
    vec4 diffuse = max(0., dot(n, l)) * color;
    OivDepthPeelingOutputColor(vec4(diffuse.rgb, color.a));
  }
}
