/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Thibaut Andrieu (Jan 2011)
**=======================================================================*/

#define BUILDING_DLL 1

#include <SoCustomPointScreenDrawer.h>

#include <Inventor/events/SoEvent.h>
#include <Inventor/actions/SoHandleEventAction.h>
#include <Inventor/events/SoKeyboardEvent.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoLightModel.h>
#include <Inventor/nodes/SoMaterial.h>

SO_NODE_SOURCE( SoCustomPointScreenDrawer );

SoCustomPointScreenDrawer::SoCustomPointScreenDrawer()
{
  SO_NODE_CONSTRUCTOR( SoCustomPointScreenDrawer );

  // create a small sceneGraph that contains a sphere.
  m_switch = new SoSwitch;
  m_switch->whichChild = SO_SWITCH_NONE;
  
  SoSeparator* separator = new SoSeparator;
  m_switch->addChild(separator);

  SoLightModel* lightModel = new SoLightModel;
  lightModel->model = SoLightModel::BASE_COLOR;
  separator->addChild(lightModel);

  SoMaterial* baseColor = new SoMaterial;
  baseColor->diffuseColor.setValue(0, 1, 0);
  separator->addChild(baseColor);
  
  m_translation = new SoTranslation;
  separator->addChild(m_translation);
  
  SoSphere* sphere = new SoSphere;
  sphere->radius = 0.1f;
  separator->addChild(sphere);

  // set our small sceneGraph as current ScreenDrawer sceneGraph.
  sceneGraph = m_switch;
}

//------------------------------------------------------------------------------
// 
SoCustomPointScreenDrawer::~SoCustomPointScreenDrawer()
{
}

//------------------------------------------------------------------------------
// 
void
SoCustomPointScreenDrawer::initClass()
{
  SO__NODE_INIT_CLASS( SoCustomPointScreenDrawer, "CustomPointScreenDrawer", SoScreenDrawer );
}

//------------------------------------------------------------------------------
// 
void
SoCustomPointScreenDrawer::exitClass()
{
  SO__NODE_EXIT_CLASS( SoCustomPointScreenDrawer );
}

//------------------------------------------------------------------------------
// Clear existing rectangle and compute a new one from m_initCorner and current mouse position.
void 
SoCustomPointScreenDrawer::onMouseDragging( SoHandleEventAction* action )
{
  const SoEvent* event = action->getEvent();
  const SbViewportRegion& viewport = action->getViewportRegion();

  float width = viewport.getWindowSize()[0];
  float height = viewport.getWindowSize()[1];

  float x =  (2.0f * event->getPosition()[0] / width) - 1.0f;
  float y =  (2.0f * event->getPosition()[1] / height) - 1.0f;

  m_translation->translation.setValue(x, y, 0);
}

//------------------------------------------------------------------------------
// save current mouse down position
void
SoCustomPointScreenDrawer::onMouseDown( SoHandleEventAction* /*action*/ )
{
  m_switch->whichChild = SO_SWITCH_ALL;
}

//------------------------------------------------------------------------------
// finalize rectangle
void
SoCustomPointScreenDrawer::onMouseUp( SoHandleEventAction* /*action*/ )
{
  m_switch->whichChild = SO_SWITCH_NONE;
}

