/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Thibaut Andrieu (Apr 2011)
**=======================================================================*/

#if !defined _SO_CUSTOM_POINT_SCREEN_DRAWER_H_
#define _SO_CUSTOM_POINT_SCREEN_DRAWER_H_

#include <Inventor/drawers/SoScreenDrawer.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoTranslation.h>

// When building the node as a DLL under Win32 we must explicitly
// declare this entry point as visible outside the DLL.
// The macro BUILDING_DLL is defined in the node's source file.
#ifdef BUILDING_DLL
#define DLL_EXPORT VC_DLL_EXPORT
#else
#define DLL_EXPORT VC_DLL_IMPORT
#endif

class DLL_EXPORT SoCustomPointScreenDrawer : public SoScreenDrawer 
{
  SO_NODE_HEADER( SoCustomPointScreenDrawer );

public:
  /** Constructor */
  SoCustomPointScreenDrawer();

SoINTERNAL public:

  /** Register in database */
  static void initClass();

  /** Unregister from database */
  static void exitClass();

SoEXTENDER_Documented protected:

  /** mouse dragging -> set point position */
  virtual void onMouseDragging( SoHandleEventAction* action );

  /** Mouse down -> set our point visible */
  virtual void onMouseDown( SoHandleEventAction* action );

  /** Mouse up -> set our point unvisible */
  virtual void onMouseUp( SoHandleEventAction* action );

protected:

  /** Destructor. */
  virtual ~SoCustomPointScreenDrawer();

private:

  /** Switch to enable/disable point */
  SoSwitch* m_switch;

  /** Position of point, in normalized screen space ([-1, 1]x[-1, 1]x[-1, 1]) */
  SoTranslation* m_translation;

};


#endif // _SO_RECTANGLE_SCREEN_DRAWER_H_


