/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Thibaut Andrieu (Jan 2011)
**=======================================================================*/

#define BUILDING_DLL 1

#include <SoCustomRectangleScreenDrawer.h>

#include <Inventor/events/SoEvent.h>
#include <Inventor/actions/SoHandleEventAction.h>
#include <Inventor/events/SoKeyboardEvent.h>

SO_NODE_SOURCE( SoCustomRectangleScreenDrawer );

SoCustomRectangleScreenDrawer::SoCustomRectangleScreenDrawer()
: m_initPoint ( SbVec2f(-1, -1) )
{
  SO_NODE_CONSTRUCTOR( SoCustomRectangleScreenDrawer );

  // no simplification is needed because rectangle will always have 4 points.
  // notify must be disabled because we are in object constructor
  simplificationThreshold.enableNotify( FALSE );
  simplificationThreshold = 0;
  simplificationThreshold.enableNotify( TRUE );

  isClosed.enableNotify( FALSE );
  isClosed = TRUE;
  isClosed.enableNotify( TRUE );

  isBuiltIn = TRUE;
}

//------------------------------------------------------------------------------
// 
SoCustomRectangleScreenDrawer::~SoCustomRectangleScreenDrawer()
{
}

//------------------------------------------------------------------------------
// 
void
SoCustomRectangleScreenDrawer::initClass()
{
  SO__NODE_INIT_CLASS( SoCustomRectangleScreenDrawer, "CustomRectangleScreenDrawer", SoPolyLineScreenDrawer );
}

//------------------------------------------------------------------------------
// 
void
SoCustomRectangleScreenDrawer::exitClass()
{
  SO__NODE_EXIT_CLASS( SoCustomRectangleScreenDrawer );
}


//------------------------------------------------------------------------------
// Clear existing rectangle and compute a new one from m_initCorner and current mouse position.
void 
SoCustomRectangleScreenDrawer::onMouseDragging( SoHandleEventAction* action )
{
  if ( !isCreating() )
    return;

  const SoEvent* event = action->getEvent();
  const SbViewportRegion& viewport = action->getViewportRegion();

  float width = viewport.getWindowSize()[0];
  float height = viewport.getWindowSize()[1];

  float x =  (2.0f * event->getPosition()[0] / width) - 1.0f;
  float y =  (2.0f * event->getPosition()[1] / height) - 1.0f;

  clear();

  //------------------------------------------------------------------------------
  // compute rectangle

  // A and B are 2 opposit corner of rectangle.
  //
  // A _________
  //  |         |
  //  |         |
  //  |_________|
  //             B = current mouse position

  SbVec2f A = m_initPoint;
  SbVec2f B(x, y);

  addPoint( A );
  addPoint( SbVec2f(A[0], B[1]) );
  addPoint( B );
  addPoint( SbVec2f(B[0], A[1]) );
}

//------------------------------------------------------------------------------
// save current mouse down position
void
SoCustomRectangleScreenDrawer::onMouseDown( SoHandleEventAction* action )
{
  const SoEvent* event = action->getEvent();
  const SbViewportRegion& viewport = action->getViewportRegion();

  float width = viewport.getWindowSize()[0];
  float height = viewport.getWindowSize()[1];

  float x =  (2.0f * event->getPosition()[0] / width) - 1.0f;
  float y =  (2.0f * event->getPosition()[1] / height) - 1.0f;

  m_initPoint.setValue(x, y);

  clear();
}

//------------------------------------------------------------------------------
// finalize rectangle
void
SoCustomRectangleScreenDrawer::onMouseUp( SoHandleEventAction* action )
{
  finalize( action );
  m_initPoint.setValue(-1, -1);
}

