/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Thibaut Andrieu (Apr 2011)
**=======================================================================*/

#if !defined _SO_CUSTOM_RECTANGLE_SCREEN_DRAWER_H_
#define _SO_CUSTOM_RECTANGLE_SCREEN_DRAWER_H_

#include <Inventor/drawers/SoPolyLineScreenDrawer.h>
#include <Inventor/fields/SoSFEnum.h>

// When building the node as a DLL under Win32 we must explicitly
// declare this entry point as visible outside the DLL.
// The macro BUILDING_DLL is defined in the node's source file.
#ifdef BUILDING_DLL
#define DLL_EXPORT VC_DLL_EXPORT
#else
#define DLL_EXPORT VC_DLL_IMPORT
#endif

/**
 * A simplfied version of OIV SoRectangleScreenDrawer.
 */
class DLL_EXPORT SoCustomRectangleScreenDrawer : public SoPolyLineScreenDrawer 
{
  SO_NODE_HEADER( SoCustomRectangleScreenDrawer );

public:
  /** Constructor */
  SoCustomRectangleScreenDrawer();

SoINTERNAL public:

  /** Register in database */
  static void initClass();

  /** Unregister from database */
  static void exitClass();

SoEXTENDER_Documented protected:

  /** Update rectangle. */
  virtual void onMouseDragging( SoHandleEventAction* action );

  /** Start creation of new rectangle. */
  virtual void onMouseDown( SoHandleEventAction* action );

  /** Finish creation of rectangle. */
  virtual void onMouseUp( SoHandleEventAction* action );

  /** Is a rectangle creating. */
  inline bool isCreating() const { return m_initPoint[0] != -1 && m_initPoint[1] != -1; }

protected:

  /** Destructor. */
  virtual ~SoCustomRectangleScreenDrawer();

private:

  /** 
   * Initial point of rectangle (usually the mouseDown event).
   * If (-1, -1), rectangle is not creating 
   */
  SbVec2f m_initPoint;

};


#endif // _SO_RECTANGLE_SCREEN_DRAWER_H_


